/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PsiDiagramNode<T extends PsiElement>
extends DiagramNodeBase<T> {
    private final SmartPsiElementPointer<T> myPointer;
    private T lastGoodPsiElement;

    public PsiDiagramNode(T psiElement, @NotNull DiagramProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diagram/PsiDiagramNode", "<init>"));
        }
        super(provider);
        this.myPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement);
        this.lastGoodPsiElement = psiElement;
    }

    @NotNull
    protected final T getElement() {
        PsiElement element = this.myPointer.getElement();
        if (element != null) {
            this.lastGoodPsiElement = element;
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/PsiDiagramNode", "getElement"));
            }
            return (T)psiElement;
        }
        T t = this.lastGoodPsiElement;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/PsiDiagramNode", "getElement"));
        }
        return t;
    }

    @Override
    public Icon getIcon() {
        return this.getElement().getIcon(0);
    }

    @Override
    @NotNull
    public T getIdentifyingElement() {
        T t = this.getElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/PsiDiagramNode", "getIdentifyingElement"));
        }
        return t;
    }
}

