/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Utils {
    public static Key<DiagramBuilder> GRAPH_BUILDER = Key.create((String)"UML_GRAPH_BUILDER");
    public static Key<List<DiagramBuilder>> GRAPH_BUILDERS = Key.create((String)"UML_GRAPH_BUILDERS");
    public static Key<DiagramProvider> UML_PROVIDER = Key.create((String)"UML_PROVIDER");

    private Utils() {
    }

    public static DiagramBuilder getBuilder(FileEditor editor) {
        return (DiagramBuilder)editor.getUserData(GRAPH_BUILDER);
    }

    public static Layouter getLayouter(Graph2D graph, Project project, DiagramLayout layout) {
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)graph);
        switch (layout) {
            case TREE: {
                return settings.getHVTreeLayouter();
            }
            case BALLOON: {
                return settings.getBalloonLayouter();
            }
            case CIRCULAR: {
                return settings.getCircularLayouter();
            }
            case DIRECTED_ORTHOGONAL: {
                return settings.getDirectedOrthogonalLayouter();
            }
            case HIERARCHIC_GROUP: {
                return settings.getGroupLayouter();
            }
            case ORGANIC: {
                return settings.getOrganicLayouter();
            }
            case ORTHOGONAL: {
                return settings.getOrthogonalLayouter();
            }
        }
        return settings.getGroupLayouter();
    }

    public static void assertForgetToRemoveEdge(Edge edge, DiagramEdge umlEdge, DiagramBuilder builder) {
        assert (edge != null) : "Seems one or more edges haven't been removed from data model. Edge: [from: " + umlEdge.getSource().getTooltip() + "; to: " + umlEdge.getTarget().getTooltip() + "]\nDouble check method implementation of removeNode(UmlNode) of UmlDataModel\nProvider ID = " + builder.getProvider().getID();
    }

    public static boolean hasNotNull(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return true;
        }
        return false;
    }

    public static Point getNodeCoordinatesOnScreen(Node node, Graph2DView view) {
        Graph2D graph2D = (Graph2D)node.getGraph();
        Point viewPoint = ((Graph2DView)graph2D.getCurrentView()).getViewPoint();
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        double x = nodeRealizer.getX();
        double y = nodeRealizer.getY();
        JComponent owner = view.getCanvasComponent();
        double oX = owner.getLocationOnScreen().getX();
        double oY = owner.getLocationOnScreen().getY();
        double pX = (x - (double)viewPoint.x) * view.getZoom() + oX;
        double pY = (y - (double)viewPoint.y) * view.getZoom() + oY;
        pX = pX < oX ? oX : pX;
        return new Point((int)pX, (int)pY);
    }

    public static Point getGraphCenterOnScreen(Graph2D graph) {
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        Dimension size = view.getViewSize();
        Point top = view.getCanvasComponent().getLocationOnScreen();
        return new Point(top.x + size.width / 2, top.y + size.height / 2);
    }

    public static Point getBestPositionForNode(GraphBuilder builder) {
        double yy = -1.7976931348623157E308;
        double xx = -1.7976931348623157E308;
        double rightest = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double leftest = Double.MAX_VALUE;
        for (Object umlNode : builder.getNodeObjects()) {
            NodeLayout nodeLayout;
            Node node = builder.getNode(umlNode);
            if (node == null || (nodeLayout = builder.getGraph().getNodeLayout((Object)node)) == null) continue;
            double w = nodeLayout.getWidth();
            double nx = nodeLayout.getX();
            double x = nx + w;
            double h = nodeLayout.getHeight();
            double ny = nodeLayout.getY();
            double y = ny + h;
            if (x > rightest) {
                rightest = x;
            }
            if (x < leftest) {
                leftest = x - w;
            }
            if (!(y >= maxY)) continue;
            xx = y == maxY ? Math.max(xx, nx) : nx;
            yy = Math.max(yy, ny);
            maxX = y == maxY ? Math.max(x, maxX) : x;
            maxY = y;
        }
        if (maxY == -1.7976931348623157E308 || maxX == -1.7976931348623157E308) {
            return new Point(200, 200);
        }
        Point p = new Point();
        if (rightest - maxX < 100.0) {
            p.setLocation(leftest, maxY + 20.0);
        } else {
            p.setLocation(maxX + 20.0, yy);
        }
        return p;
    }

    public static Document readUmlFileFromFile(InputStream is) throws JDOMException, IOException {
        return new SAXBuilder().build(is);
    }

    public static DiagramElementsProvider[] getElementProviders(DiagramProvider provider) {
        if (provider == null) {
            return DiagramElementsProvider.EMPTY_ARRAY;
        }
        DiagramElementsProvider<T>[] providers = provider.getExtras().getElementsProviders();
        return providers == null || providers.length == 0 ? DiagramElementsProvider.EMPTY_ARRAY : providers;
    }

    public static String getNodeName(DiagramNode node) {
        DiagramBuilder builder;
        if (node != null && (builder = (DiagramBuilder)node.getUserData(GRAPH_BUILDER)) != null) {
            return builder.getProvider().getElementManager().getItemName(node.getIdentifyingElement(), builder.getPresentation()).toString();
        }
        return node.getTooltip();
    }

    public static void showPopupBeneathNode(JBPopup popup, Node node, Graph2DView view) {
        Point p = Utils.getNodeCoordinatesOnScreen(node, view);
        popup.showInScreenCoordinates((Component)view.getCanvasComponent(), new Point(p.x, p.y + (int)(24.0 * view.getZoom())));
    }

    public static void showInGraphCenter(JBPopup popup, Graph2D graph) {
        Point p = Utils.getGraphCenterOnScreen(graph);
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        popup.showInScreenCoordinates((Component)view.getCanvasComponent(), new Point(p.x - 100, p.y - 100));
    }

    public static List<DiagramNode> getSelectedNodesExceptNotes(DiagramBuilder builder) {
        ArrayList<DiagramNode> selected = new ArrayList<DiagramNode>();
        for (DiagramNode umlNode : builder.getNodeObjects()) {
            if (umlNode instanceof DiagramNoteNode || !builder.getGraph().isSelected(builder.getNode(umlNode))) continue;
            selected.add(umlNode);
        }
        return selected;
    }

    public static List<DiagramNode> getNodesExceptNotes(DiagramBuilder builder) {
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>();
        for (DiagramNode umlNode : builder.getNodeObjects()) {
            if (umlNode instanceof DiagramNoteNode) continue;
            nodes.add(umlNode);
        }
        return nodes;
    }
}

