/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiagramDefaultAddElementAction<T>
extends DiagramAddElementAction {
    public void gotoActionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final DiagramBuilder builder = DiagramAction.getBuilder(e);
        if (project == null || builder == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup((Project)project, (ChooseByNameModel)this.createModel(project), (PsiElement)DiagramDefaultAddElementAction.getPsiContext((AnActionEvent)e));
        popup.invoke((ChooseByNamePopupComponent.Callback)new ChooseByNamePopupComponent.MultiElementsCallback(){

            public void onClose() {
                if (DiagramDefaultAddElementAction.class.isAssignableFrom(myInAction)) {
                    myInAction = null;
                }
            }

            public void elementsChosen(List<Object> elements) {
                Runnable callback = () -> {
                    DiagramDataModel dataModel = builder.getDataModel();
                    ArrayList<DiagramNode<Object>> chosenNodes = new ArrayList<DiagramNode<Object>>();
                    for (Object e : elements) {
                        DiagramNode<Object> node;
                        Object modelElement = DiagramDefaultAddElementAction.this.convertElement(e);
                        if (!builder.getProvider().getElementManager().isAcceptableAsNode(modelElement) || (node = dataModel.addElement(modelElement)) == null) continue;
                        builder.createDraggedNode(node, node.getTooltip(), DiagramUtils.getBestPositionForNode(builder));
                        builder.updateGraph();
                        chosenNodes.add(node);
                    }
                    if (chosenNodes.size() > 0) {
                        builder.getGraph().selectAllNodesAndBends(false);
                        for (DiagramNode diagramNode : chosenNodes) {
                            Node node = builder.getNode(diagramNode);
                            if (node == null) continue;
                            builder.getGraph().setSelected(node, true);
                        }
                    }
                    builder.requestFocus();
                };
                DiagramAction.createCallback(builder, new PopupCallback.Adapter(callback, "Add Element to Diagram")).run();
            }
        }, ModalityState.current(), true);
    }

    @NotNull
    protected Object convertElement(@NotNull Object element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/diagram/actions/DiagramDefaultAddElementAction", "convertElement"));
        }
        Object object = element;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/actions/DiagramDefaultAddElementAction", "convertElement"));
        }
        return object;
    }

    protected GotoClassModel2 createModel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagram/actions/DiagramDefaultAddElementAction", "createModel"));
        }
        return new UmlAddClassModel(project);
    }

    @Override
    public String getText() {
        return "Add Class to Diagram...";
    }

    protected boolean hasContributors(DataContext dataContext) {
        return ChooseByNameRegistry.getInstance().getClassModelContributors().length > 0;
    }

    private static class UmlAddClassModel
    extends GotoClassModel2 {
        public UmlAddClassModel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diagram/actions/DiagramDefaultAddElementAction$UmlAddClassModel", "<init>"));
            }
            super(project);
        }

        public String getPromptText() {
            return "Enter class name to add";
        }
    }
}

