/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote;

import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.server.internal.remote.DebugPrintStream;
import com.google.dart.server.internal.remote.RequestSink;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ByteRequestSink
implements RequestSink {
    private final PrintWriter writer;
    private DebugPrintStream debugStream;
    private final BlockingQueue<String> lineQueue = new LinkedBlockingQueue<String>();

    public ByteRequestSink(OutputStream stream, DebugPrintStream debugStream) {
        this.writer = new PrintWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        this.debugStream = debugStream;
        new LinesWriterThread().start();
    }

    @Override
    public void add(JsonObject request) {
        String text = request.toString();
        if (this.debugStream != null && !text.contains("server.getVersion")) {
            this.debugStream.println(System.currentTimeMillis() + " => " + text);
        }
        this.lineQueue.add(text);
    }

    @Override
    public void close() {
        this.writer.close();
        this.lineQueue.add("EOF line");
    }

    public void waitForFlush() {
        while (!this.lineQueue.isEmpty()) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return;
    }

    private class LinesWriterThread
    extends Thread {
        public LinesWriterThread() {
            this.setName("ByteRequestSink.LinesWriterThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = (String)ByteRequestSink.this.lineQueue.take()) == "EOF line") {
                            return;
                        }
                        ByteRequestSink.this.writer.println(line);
                        ByteRequestSink.this.writer.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

