/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.FindElementReferencesConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonObject;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.RequestError;

public class FindElementReferencesProcessor
extends ResultProcessor {
    private final FindElementReferencesConsumer consumer;

    public FindElementReferencesProcessor(FindElementReferencesConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                String searchId = resultObject.has("id") ? resultObject.get("id").getAsString() : null;
                Element element = resultObject.has("element") ? Element.fromJson(resultObject.get("element").getAsJsonObject()) : null;
                this.consumer.computedElementReferences(searchId, element);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

