/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.FormatConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SourceEdit;

public class FormatProcessor
extends ResultProcessor {
    private final FormatConsumer consumer;

    public FormatProcessor(FormatConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                List<SourceEdit> edits = SourceEdit.fromJsonArray(resultObject.get("edits").getAsJsonArray());
                int selectionOffset = resultObject.get("selectionOffset").getAsInt();
                int selectionLength = resultObject.get("selectionLength").getAsInt();
                this.consumer.computedFormat(edits, selectionOffset, selectionLength);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

