/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetNavigationConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.NavigationTarget;
import org.dartlang.analysis.server.protocol.RequestError;

public class GetNavigationProcessor
extends ResultProcessor {
    private final GetNavigationConsumer consumer;

    public GetNavigationProcessor(GetNavigationConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                String[] targetFiles = this.constructStringArray(resultObject.get("files").getAsJsonArray());
                List<NavigationTarget> targets = NavigationTarget.fromJsonArray(resultObject.get("targets").getAsJsonArray());
                for (NavigationTarget target : targets) {
                    target.lookupFile(targetFiles);
                }
                JsonArray regionsArray = resultObject.get("regions").getAsJsonArray();
                List<NavigationRegion> regions = NavigationRegion.fromJsonArray(regionsArray);
                for (NavigationRegion region : regions) {
                    region.lookupTargets(targets);
                }
                this.consumer.computedNavigation(regions);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

