/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetRefactoringConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.ExtractLocalVariableFeedback;
import org.dartlang.analysis.server.protocol.ExtractMethodFeedback;
import org.dartlang.analysis.server.protocol.InlineLocalVariableFeedback;
import org.dartlang.analysis.server.protocol.InlineMethodFeedback;
import org.dartlang.analysis.server.protocol.RefactoringFeedback;
import org.dartlang.analysis.server.protocol.RefactoringProblem;
import org.dartlang.analysis.server.protocol.RenameFeedback;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.SourceChange;

public class GetRefactoringProcessor
extends ResultProcessor {
    private final Map<String, String> requestToRefactoringKindMap;
    private final GetRefactoringConsumer consumer;

    public GetRefactoringProcessor(Map<String, String> requestToRefactoringKindMap, GetRefactoringConsumer consumer) {
        this.requestToRefactoringKindMap = requestToRefactoringKindMap;
        this.consumer = consumer;
    }

    public void process(String requestId, JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                List<RefactoringProblem> initialProblems = this.getRefactoringProblems(resultObject, "initialProblems");
                List<RefactoringProblem> optionsProblems = this.getRefactoringProblems(resultObject, "optionsProblems");
                List<RefactoringProblem> finalProblems = this.getRefactoringProblems(resultObject, "finalProblems");
                SourceChange change = null;
                if (resultObject.has("change")) {
                    change = SourceChange.fromJson(resultObject.get("change").getAsJsonObject());
                }
                List<String> potentialEdits = JsonUtilities.decodeStringList(resultObject.get("potentialEdits") != null ? resultObject.get("potentialEdits").getAsJsonArray() : null);
                RefactoringFeedback feedback = null;
                if (resultObject.has("feedback")) {
                    JsonObject feedbackObject = resultObject.get("feedback").getAsJsonObject();
                    String kind = this.requestToRefactoringKindMap.remove(requestId);
                    if ("EXTRACT_LOCAL_VARIABLE".equals(kind)) {
                        feedback = ExtractLocalVariableFeedback.fromJson(feedbackObject);
                    } else if ("EXTRACT_METHOD".equals(kind)) {
                        feedback = ExtractMethodFeedback.fromJson(feedbackObject);
                    } else if ("INLINE_LOCAL_VARIABLE".equals(kind)) {
                        feedback = InlineLocalVariableFeedback.fromJson(feedbackObject);
                    } else if ("INLINE_METHOD".equals(kind)) {
                        feedback = InlineMethodFeedback.fromJson(feedbackObject);
                    } else if ("RENAME".equals(kind)) {
                        feedback = RenameFeedback.fromJson(feedbackObject);
                    }
                }
                this.consumer.computedRefactorings(initialProblems, optionsProblems, finalProblems, feedback, change, potentialEdits);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }

    private List<RefactoringProblem> getRefactoringProblems(JsonObject resultObject, String name) {
        return RefactoringProblem.fromJsonArray(resultObject.get(name).getAsJsonArray());
    }
}

