/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.common.reflect.TypeToken;
import com.google.dart.server.GetLibraryDependenciesConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.RequestError;

public class LibraryDependenciesProcessor
extends ResultProcessor {
    private static final Map<String, Map<String, List<String>>> EMPTY_MAP = Collections.emptyMap();
    private final GetLibraryDependenciesConsumer consumer;

    private static Map<String, Map<String, List<String>>> constructPackageMap(JsonElement jsonMap) {
        if (jsonMap == null) {
            return EMPTY_MAP;
        }
        return (Map)new Gson().fromJson(jsonMap, new TypeToken<Map<String, Map<String, List<String>>>>(){}.getType());
    }

    public LibraryDependenciesProcessor(GetLibraryDependenciesConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                String[] libraries = this.constructStringArray(resultObject.get("libraries").getAsJsonArray());
                Map<String, Map<String, List<String>>> packageMap = LibraryDependenciesProcessor.constructPackageMap(resultObject.get("packageMap"));
                this.consumer.computedDependencies(libraries, packageMap);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

