/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.MapUriConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonObject;
import org.dartlang.analysis.server.protocol.RequestError;

public class MapUriProcessor
extends ResultProcessor {
    private MapUriConsumer consumer;

    public MapUriProcessor(MapUriConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                String file = this.safelyGetAsString(resultObject, "file");
                String uri = this.safelyGetAsString(resultObject, "uri");
                this.consumer.computedFileOrUri(file, uri);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

