/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.internal.remote.processor.NotificationProcessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.NavigationTarget;

public class NotificationAnalysisNavigationProcessor
extends NotificationProcessor {
    public NotificationAnalysisNavigationProcessor(AnalysisServerListener listener) {
        super(listener);
    }

    @Override
    public void process(JsonObject response) throws Exception {
        JsonObject paramsObject = response.get("params").getAsJsonObject();
        String file = paramsObject.get("file").getAsString();
        String[] targetFiles = this.constructStringArray(paramsObject.get("files").getAsJsonArray());
        List<NavigationTarget> targets = NavigationTarget.fromJsonArray(paramsObject.get("targets").getAsJsonArray());
        for (NavigationTarget target : targets) {
            target.lookupFile(targetFiles);
        }
        JsonArray regionsArray = paramsObject.get("regions").getAsJsonArray();
        List<NavigationRegion> regions = NavigationRegion.fromJsonArray(regionsArray);
        for (NavigationRegion region : regions) {
            region.lookupTargets(targets);
        }
        this.getListener().computedNavigation(file, regions);
    }
}

