/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.internal.remote.processor.NotificationProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.dartlang.analysis.server.protocol.AnalysisStatus;
import org.dartlang.analysis.server.protocol.PubStatus;

public class NotificationServerStatusProcessor
extends NotificationProcessor {
    public NotificationServerStatusProcessor(AnalysisServerListener listener) {
        super(listener);
    }

    @Override
    public void process(JsonObject response) throws Exception {
        JsonObject paramsObject = response.get("params").getAsJsonObject();
        AnalysisStatus analysisStatus = this.getAnalysisStatus(paramsObject);
        PubStatus pubStatus = this.getPubStatus(paramsObject);
        this.getListener().serverStatus(analysisStatus, pubStatus);
    }

    private AnalysisStatus getAnalysisStatus(JsonObject paramsObject) {
        JsonElement analysisMember = paramsObject.get("analysis");
        if (analysisMember == null) {
            return null;
        }
        JsonObject analysisObject = analysisMember.getAsJsonObject();
        boolean isAnalyzing = analysisObject.get("isAnalyzing").getAsBoolean();
        String analysisTarget = this.safelyGetAsString(analysisObject, "analysisTarget");
        return new AnalysisStatus(isAnalyzing, analysisTarget);
    }

    private PubStatus getPubStatus(JsonObject paramsObject) {
        JsonElement pubMember = paramsObject.get("pub");
        if (pubMember == null) {
            return null;
        }
        JsonObject pubObject = pubMember.getAsJsonObject();
        boolean isListingPackageDirs = pubObject.get("isListingPackageDirs").getAsBoolean();
        return new PubStatus(isListingPackageDirs);
    }
}

