/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetAvailableRefactoringsConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.dart.server.utilities.general.JsonUtilities;
import com.google.gson.JsonObject;
import java.util.List;
import org.dartlang.analysis.server.protocol.RequestError;

public class RefactoringGetAvailableProcessor
extends ResultProcessor {
    private final GetAvailableRefactoringsConsumer consumer;

    public RefactoringGetAvailableProcessor(GetAvailableRefactoringsConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                List<String> refactoringKinds = JsonUtilities.decodeStringList(resultObject.get("kinds").getAsJsonArray());
                this.consumer.computedRefactoringKinds(refactoringKinds);
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

