/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.processor;

import com.google.dart.server.GetTypeHierarchyConsumer;
import com.google.dart.server.internal.remote.processor.ResultProcessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.dartlang.analysis.server.protocol.RequestError;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;

public class TypeHierarchyProcessor
extends ResultProcessor {
    private final GetTypeHierarchyConsumer consumer;

    public TypeHierarchyProcessor(GetTypeHierarchyConsumer consumer) {
        this.consumer = consumer;
    }

    public void process(JsonObject resultObject, RequestError requestError) {
        if (resultObject != null) {
            try {
                JsonArray typeHierarchyItemsArray = resultObject.get("hierarchyItems") != null ? resultObject.get("hierarchyItems").getAsJsonArray() : null;
                this.consumer.computedHierarchy(TypeHierarchyItem.fromJsonArray(typeHierarchyItemsArray));
            }
            catch (Exception exception) {
                requestError = this.generateRequestError(exception);
            }
        }
        if (requestError != null) {
            this.consumer.onError(requestError);
        }
    }
}

