/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.internal.remote.utilities;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.AddContentOverlay;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.AnalysisOptions;
import org.dartlang.analysis.server.protocol.ChangeContentOverlay;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.RefactoringOptions;
import org.dartlang.analysis.server.protocol.RemoveContentOverlay;

public class RequestUtilities {
    private static final String CONTEXT_ROOT = "contextRoot";
    private static final String FILE = "file";
    private static final String ID = "id";
    private static final String LENGTH = "length";
    private static final String LINE_LENGTH = "lineLength";
    private static final String METHOD = "method";
    private static final String OFFSET = "offset";
    private static final String PARAMS = "params";
    private static final String CLIENT_REQUEST_TIME = "clientRequestTime";
    private static final String SELECTION_LENGTH = "selectionLength";
    private static final String SELECTION_OFFSET = "selectionOffset";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final String SUPER_ONLY = "superOnly";
    private static final String URI = "uri";
    private static final String METHOD_SERVER_GET_VERSION = "server.getVersion";
    private static final String METHOD_SERVER_SHUTDOWN = "server.shutdown";
    private static final String METHOD_SERVER_SET_SUBSCRIPTIONS = "server.setSubscriptions";
    private static final String METHOD_ANALYSIS_GET_ERRORS = "analysis.getErrors";
    private static final String METHOD_ANALYSIS_GET_HOVER = "analysis.getHover";
    private static final String METHOD_ANALYSIS_GET_LIBRARY_DEPENDENCIES = "analysis.getLibraryDependencies";
    private static final String METHOD_ANALYSIS_GET_NAVIGATION = "analysis.getNavigation";
    private static final String METHOD_ANALYSIS_REANALYZE = "analysis.reanalyze";
    private static final String METHOD_ANALYSIS_SET_GENERAL_SUBSCRIPTIONS = "analysis.setGeneralSubscriptions";
    private static final String METHOD_ANALYSIS_SET_ROOTS = "analysis.setAnalysisRoots";
    private static final String METHOD_ANALYSIS_SET_PRIORITY_FILES = "analysis.setPriorityFiles";
    private static final String METHOD_ANALYSIS_SET_SUBSCRIPTIONS = "analysis.setSubscriptions";
    private static final String METHOD_ANALYSIS_UPDATE_CONTENT = "analysis.updateContent";
    private static final String METHOD_ANALYSIS_UPDATE_OPTIONS = "analysis.updateOptions";
    private static final String METHOD_EDIT_FORMAT = "edit.format";
    private static final String METHOD_EDIT_GET_ASSISTS = "edit.getAssists";
    private static final String METHOD_EDIT_GET_AVAILABLE_REFACTORING = "edit.getAvailableRefactorings";
    private static final String METHOD_EDIT_GET_FIXES = "edit.getFixes";
    private static final String METHOD_EDIT_GET_REFACTORING = "edit.getRefactoring";
    private static final String METHOD_EDIT_ORGANIZE_DIRECTIVES = "edit.organizeDirectives";
    private static final String METHOD_EDIT_SORT_MEMBERS = "edit.sortMembers";
    private static final String METHOD_COMPLETION_GET_SUGGESTIONS = "completion.getSuggestions";
    private static final String METHOD_SEARCH_FIND_ELEMENT_REFERENCES = "search.findElementReferences";
    private static final String METHOD_SEARCH_FIND_MEMBER_DECLARATIONS = "search.findMemberDeclarations";
    private static final String METHOD_SEARCH_FIND_MEMBER_REFERENCES = "search.findMemberReferences";
    private static final String METHOD_SEARCH_FIND_TOP_LEVEL_DECLARATIONS = "search.findTopLevelDeclarations";
    private static final String METHOD_SEARCH_GET_TYPE_HIERARCHY = "search.getTypeHierarchy";
    private static final String METHOD_EXECUTION_CREATE_CONTEXT = "execution.createContext";
    private static final String METHOD_EXECUTION_DELETE_CONTEXT = "execution.deleteContext";
    private static final String METHOD_EXECUTION_MAP_URI = "execution.mapUri";
    private static final String METHOD_EXECUTION_SET_SUBSCRIPTIONS = "execution.setSubscriptions";
    private static final String METHOD_DIAGNOSTIC_GET_SERVER_PORT = "diagnostic.getServerPort";
    private static boolean includeRequestTime = true;

    @VisibleForTesting
    public static JsonElement buildJsonElement(Object object) {
        if (object instanceof Boolean) {
            return new JsonPrimitive((Boolean)object);
        }
        if (object instanceof Number) {
            return new JsonPrimitive((Number)object);
        }
        if (object instanceof String) {
            return new JsonPrimitive((String)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            JsonArray jsonArray = new JsonArray();
            for (Object item : list) {
                JsonElement jsonItem = RequestUtilities.buildJsonElement(item);
                jsonArray.add(jsonItem);
            }
            return jsonArray;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Unable to convert to string: " + RequestUtilities.getClassName(key));
                }
                String keyString = (String)key;
                Object value = entry.getValue();
                JsonElement valueJson = RequestUtilities.buildJsonElement(value);
                if (keyString == null || valueJson == null) continue;
                jsonObject.add(keyString, valueJson);
            }
            return jsonObject;
        }
        if (object instanceof AnalysisError) {
            return RequestUtilities.buildJsonObjectAnalysisError((AnalysisError)object);
        }
        if (object instanceof AddContentOverlay) {
            return ((AddContentOverlay)object).toJson();
        }
        if (object instanceof ChangeContentOverlay) {
            return ((ChangeContentOverlay)object).toJson();
        }
        if (object instanceof RemoveContentOverlay) {
            return ((RemoveContentOverlay)object).toJson();
        }
        if (object instanceof AnalysisOptions) {
            return ((AnalysisOptions)object).toJson();
        }
        if (object instanceof Location) {
            return RequestUtilities.buildJsonObjectLocation((Location)object);
        }
        throw new IllegalArgumentException("Unable to convert to JSON: " + object);
    }

    public static JsonObject generateAnalysisGetErrors(String idValue, String file) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_GET_ERRORS, params);
    }

    public static JsonObject generateAnalysisGetHover(String idValue, String file, int offset) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_GET_HOVER, params);
    }

    public static JsonObject generateAnalysisGetLibraryDependencies(String id) {
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_GET_LIBRARY_DEPENDENCIES);
    }

    public static JsonObject generateAnalysisGetNavigation(String idValue, String file, int offset, int length) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty(LENGTH, (Number)length);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_GET_NAVIGATION, params);
    }

    public static JsonObject generateAnalysisReanalyze(String id, List<String> roots) {
        if (roots != null) {
            JsonObject params = new JsonObject();
            params.add("roots", RequestUtilities.buildJsonElement(roots));
            return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_REANALYZE, params);
        }
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_REANALYZE);
    }

    public static JsonObject generateAnalysisSetAnalysisRoots(String id, List<String> included, List<String> excluded, Map<String, String> packageRoots) {
        JsonObject params = new JsonObject();
        params.add("included", RequestUtilities.buildJsonElement(included));
        params.add("excluded", RequestUtilities.buildJsonElement(excluded));
        if (packageRoots != null) {
            params.add("packageRoots", RequestUtilities.buildJsonElement(packageRoots));
        }
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_SET_ROOTS, params);
    }

    public static JsonObject generateAnalysisSetGeneralSubscriptions(String idValue, List<String> subscriptions) {
        JsonObject params = new JsonObject();
        params.add(SUBSCRIPTIONS, RequestUtilities.buildJsonElement(subscriptions));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_SET_GENERAL_SUBSCRIPTIONS, params);
    }

    public static JsonObject generateAnalysisSetPriorityFiles(String id, List<String> files) {
        JsonObject params = new JsonObject();
        params.add("files", RequestUtilities.buildJsonElement(files));
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_SET_PRIORITY_FILES, params);
    }

    public static JsonObject generateAnalysisSetSubscriptions(String id, Map<String, List<String>> subscriptions) {
        JsonObject params = new JsonObject();
        params.add(SUBSCRIPTIONS, RequestUtilities.buildJsonElement(subscriptions));
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_ANALYSIS_SET_SUBSCRIPTIONS, params);
    }

    public static JsonObject generateAnalysisUpdateContent(String idValue, Map<String, Object> files) {
        JsonObject params = new JsonObject();
        params.add("files", RequestUtilities.buildJsonElement(files));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_UPDATE_CONTENT, params);
    }

    public static JsonObject generateAnalysisUpdateOptions(String idValue, AnalysisOptions options) {
        JsonObject params = new JsonObject();
        params.add("options", RequestUtilities.buildJsonElement(options));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_ANALYSIS_UPDATE_OPTIONS, params);
    }

    public static JsonObject generateCompletionGetSuggestions(String idValue, String file, int offset) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_COMPLETION_GET_SUGGESTIONS, params);
    }

    public static JsonObject generateEditFormat(String idValue, String file, int offset, int length, int lineLength) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(SELECTION_OFFSET, (Number)offset);
        params.addProperty(SELECTION_LENGTH, (Number)length);
        if (lineLength != -1) {
            params.addProperty(LINE_LENGTH, (Number)lineLength);
        }
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_FORMAT, params);
    }

    public static JsonObject generateEditGetAssists(String idValue, String file, int offset, int length) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty(LENGTH, (Number)length);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_GET_ASSISTS, params);
    }

    public static JsonObject generateEditGetAvaliableRefactorings(String idValue, String file, int offset, int length) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty(LENGTH, (Number)length);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_GET_AVAILABLE_REFACTORING, params);
    }

    public static JsonObject generateEditGetFixes(String idValue, String file, int offset) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_GET_FIXES, params);
    }

    public static JsonObject generateEditGetRefactoring(String idValue, String kind, String file, int offset, int length, boolean validateOnly, RefactoringOptions options) {
        JsonObject params = new JsonObject();
        params.addProperty("kind", kind);
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty(LENGTH, (Number)length);
        params.addProperty("validateOnly", Boolean.valueOf(validateOnly));
        if (options != null) {
            params.add("options", (JsonElement)options.toJson());
        }
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_GET_REFACTORING, params);
    }

    public static JsonObject generateEditOrganizeDirectives(String idValue, String file) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_ORGANIZE_DIRECTIVES, params);
    }

    public static JsonObject generateEditSortMembers(String idValue, String file) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EDIT_SORT_MEMBERS, params);
    }

    public static JsonObject generateExecutionCreateContext(String idValue, String contextRoot) {
        JsonObject params = new JsonObject();
        params.addProperty(CONTEXT_ROOT, contextRoot);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EXECUTION_CREATE_CONTEXT, params);
    }

    public static JsonObject generateExecutionDeleteContext(String idValue, String contextId) {
        JsonObject params = new JsonObject();
        params.addProperty(ID, contextId);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EXECUTION_DELETE_CONTEXT, params);
    }

    public static JsonObject generateExecutionMapUri(String idValue, String contextId, String file, String uri) {
        JsonObject params = new JsonObject();
        params.addProperty(ID, contextId);
        if (file == null) {
            if (uri == null) {
                throw new IllegalArgumentException("Exactly one of 'file' and 'uri' must be non-null");
            }
            params.addProperty(URI, uri);
        } else {
            if (uri != null) {
                throw new IllegalArgumentException("Exactly one of 'file' and 'uri' must be non-null");
            }
            params.addProperty(FILE, file);
        }
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EXECUTION_MAP_URI, params);
    }

    public static JsonObject generateExecutionSetSubscriptions(String idValue, List<String> subscriptions) {
        JsonObject params = new JsonObject();
        params.add(SUBSCRIPTIONS, RequestUtilities.buildJsonElement(subscriptions));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_EXECUTION_SET_SUBSCRIPTIONS, params);
    }

    public static JsonObject generateSearchFindElementReferences(String idValue, String file, int offset, boolean includePotential) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty("includePotential", Boolean.valueOf(includePotential));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SEARCH_FIND_ELEMENT_REFERENCES, params);
    }

    public static JsonObject generateSearchFindMemberDeclarations(String idValue, String name) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SEARCH_FIND_MEMBER_DECLARATIONS, params);
    }

    public static JsonObject generateSearchFindMemberReferences(String idValue, String name) {
        JsonObject params = new JsonObject();
        params.addProperty("name", name);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SEARCH_FIND_MEMBER_REFERENCES, params);
    }

    public static JsonObject generateSearchFindTopLevelDeclarations(String idValue, String pattern) {
        JsonObject params = new JsonObject();
        params.addProperty("pattern", pattern);
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SEARCH_FIND_TOP_LEVEL_DECLARATIONS, params);
    }

    public static JsonObject generateSearchGetTypeHierarchy(String id, String file, int offset, boolean superOnly) {
        JsonObject params = new JsonObject();
        params.addProperty(FILE, file);
        params.addProperty(OFFSET, (Number)offset);
        params.addProperty(SUPER_ONLY, Boolean.valueOf(superOnly));
        return RequestUtilities.buildJsonObjectRequest(id, METHOD_SEARCH_GET_TYPE_HIERARCHY, params);
    }

    public static JsonObject generateServerGetVersion(String idValue) {
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SERVER_GET_VERSION);
    }

    public static JsonObject generateServerSetSubscriptions(String idValue, List<String> subscriptions) {
        JsonObject params = new JsonObject();
        params.add(SUBSCRIPTIONS, RequestUtilities.buildJsonElement(subscriptions));
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SERVER_SET_SUBSCRIPTIONS, params);
    }

    public static JsonObject generateServerShutdown(String idValue) {
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_SERVER_SHUTDOWN);
    }

    public static JsonObject generateDiagnosticGetServerPort(String idValue) {
        return RequestUtilities.buildJsonObjectRequest(idValue, METHOD_DIAGNOSTIC_GET_SERVER_PORT);
    }

    public static String getId(JsonObject request) {
        return request.getAsJsonPrimitive(ID).getAsString();
    }

    public static boolean isVersionRequest(JsonObject request) {
        String method = RequestUtilities.getRequestMethod(request);
        return METHOD_SERVER_GET_VERSION.equals(method);
    }

    public static void setIncludeRequestTime(boolean includeRequestTime) {
        RequestUtilities.includeRequestTime = includeRequestTime;
    }

    private static JsonObject buildJsonObjectAnalysisError(AnalysisError error) {
        JsonObject errorJsonObject = new JsonObject();
        errorJsonObject.addProperty("severity", error.getSeverity());
        errorJsonObject.addProperty("type", error.getType());
        errorJsonObject.add("location", (JsonElement)RequestUtilities.buildJsonObjectLocation(error.getLocation()));
        errorJsonObject.addProperty("message", error.getMessage());
        String correction = error.getCorrection();
        if (correction != null) {
            errorJsonObject.addProperty("correction", correction);
        }
        return errorJsonObject;
    }

    private static JsonObject buildJsonObjectLocation(Location location) {
        JsonObject locationJsonObject = new JsonObject();
        locationJsonObject.addProperty(FILE, location.getFile());
        locationJsonObject.addProperty(OFFSET, (Number)location.getOffset());
        locationJsonObject.addProperty(LENGTH, (Number)location.getLength());
        locationJsonObject.addProperty("startLine", (Number)location.getStartLine());
        locationJsonObject.addProperty("startColumn", (Number)location.getStartColumn());
        return locationJsonObject;
    }

    private static JsonObject buildJsonObjectRequest(String idValue, String methodValue) {
        return RequestUtilities.buildJsonObjectRequest(idValue, methodValue, null);
    }

    private static JsonObject buildJsonObjectRequest(String idValue, String methodValue, JsonObject params) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(ID, idValue);
        jsonObject.addProperty(METHOD, methodValue);
        if (params != null) {
            jsonObject.add(PARAMS, (JsonElement)params);
        }
        if (includeRequestTime) {
            jsonObject.addProperty(CLIENT_REQUEST_TIME, (Number)System.currentTimeMillis());
        }
        return jsonObject;
    }

    private static String getClassName(Object object) {
        return object != null ? object.getClass().getName() : "null";
    }

    private static String getRequestMethod(JsonObject request) {
        JsonElement child = request.get(METHOD);
        if (child instanceof JsonPrimitive) {
            return child.getAsString();
        }
        return null;
    }

    private RequestUtilities() {
    }
}

