/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.server.utilities.instrumentation;

import com.google.dart.server.utilities.instrumentation.Base64;
import com.google.dart.server.utilities.instrumentation.Instrumentation;
import com.google.dart.server.utilities.instrumentation.InstrumentationBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

public class HealthUtils {
    public static long getMaxMem() {
        long max = Long.MAX_VALUE;
        try {
            Method maxMemMethod = Runtime.class.getMethod("maxMemory", new Class[0]);
            Object o = maxMemMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
            if (o instanceof Long) {
                max = (Long)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max;
    }

    public static void logMemory(InstrumentationBuilder instrumentation) {
        instrumentation.metric("MexMemory-FeedbackUtils", HealthUtils.getMaxMem());
        instrumentation.metric("TotalMemory", Runtime.getRuntime().totalMemory());
        instrumentation.metric("FreeMemory", Runtime.getRuntime().freeMemory());
    }

    public static void logThreads(InstrumentationBuilder instrumentation) {
        ThreadMXBean th = ManagementFactory.getThreadMXBean();
        ThreadInfo[] thInfos = th.getThreadInfo(th.getAllThreadIds(), Integer.MAX_VALUE);
        instrumentation.metric("threads-count", thInfos.length);
        for (ThreadInfo thInfo : thInfos) {
            if (thInfo == null) {
                instrumentation.metric("Thread-Name", "<unknown>");
                continue;
            }
            instrumentation.metric("Thread-Name", thInfo.getThreadName());
            instrumentation.metric("Thread-ID", thInfo.getThreadId());
            instrumentation.metric("Thread-State", thInfo.getThreadState().toString());
            instrumentation.metric("Blocked-Count", thInfo.getBlockedCount());
            instrumentation.metric("Blocked-Time", thInfo.getBlockedTime());
            instrumentation.metric("Waited-Count", thInfo.getWaitedCount());
            instrumentation.metric("Waited-Time", thInfo.getWaitedTime());
            instrumentation.data("Thread-ST", Base64.encodeBytes(HealthUtils.stackTraceToString(thInfo.getStackTrace()).getBytes()));
        }
    }

    public static void ReportHealth(final String reason) {
        new Thread(){

            @Override
            public void run() {
                HealthUtils.ReportHealthImpl(reason);
            }
        }.start();
    }

    private static void ReportHealthImpl(String reason) {
        InstrumentationBuilder instrumentation = Instrumentation.builder("HealthReport");
        try {
            instrumentation.metric("Reason", reason);
            HealthUtils.logMemory(instrumentation);
            HealthUtils.logThreads(instrumentation);
        }
        finally {
            instrumentation.log();
        }
    }

    private static String stackTraceToString(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : elements) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

