/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryProperties;
import com.jetbrains.lang.dart.sdk.DartPackagesLibraryType;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DotPackagesFileUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFileListener
extends VirtualFileAdapter {
    private static final Key<Boolean> DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS = Key.create((String)"DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS");
    private final Project myProject;

    public DartFileListener(Project project) {
        this.myProject = project;
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "beforePropertyChange"));
        }
        this.propertyChanged(event);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "propertyChanged"));
        }
        if ("name".equals(event.getPropertyName())) {
            DartFileListener.fileChanged(this.myProject, event.getFile());
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "contentsChanged"));
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "fileCreated"));
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "fileDeleted"));
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "fileMoved"));
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/DartFileListener", "fileCopied"));
        }
        DartFileListener.fileChanged(this.myProject, event.getFile());
    }

    private static void fileChanged(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile pubspec;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "fileChanged"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/DartFileListener", "fileChanged"));
        }
        if (!".packages".equals(file.getName())) {
            return;
        }
        if (LocalFileSystem.getInstance() != file.getFileSystem() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = pubspec = parent == null ? null : parent.findChild("pubspec.yaml");
        if (pubspec != null) {
            DartFileListener.scheduleDartPackageRootsUpdate(project);
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)pubspec, (Project)project);
            if (module != null) {
                DartProjectComponent.excludeBuildAndPackagesFolders(module, pubspec);
            }
        }
    }

    public static void setDartPackageRootUpdateScheduledOrInProgress(@NotNull Project project, boolean scheduledOrInProgress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "setDartPackageRootUpdateScheduledOrInProgress"));
        }
        if (scheduledOrInProgress) {
            project.putUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS, (Object)true);
        } else {
            project.putUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS, null);
        }
    }

    public static void scheduleDartPackageRootsUpdate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "scheduleDartPackageRootsUpdate"));
        }
        if (Registry.is((String)"dart.projects.without.pubspec", (boolean)false)) {
            return;
        }
        if (project.getUserData(DART_PACKAGE_ROOTS_UPDATE_SCHEDULED_OR_IN_PROGRESS) == Boolean.TRUE) {
            return;
        }
        DartFileListener.setDartPackageRootUpdateScheduledOrInProgress(project, Boolean.TRUE);
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "lambda$scheduleDartPackageRootsUpdate$1"));
            }
            try {
                Library library = DartFileListener.actualizePackagesLibrary(project);
                if (library == null) {
                    DartFileListener.removeDartPackagesLibraryAndDependencies(project);
                } else {
                    Condition moduleFilter = module -> DartSdkLibUtil.isDartSdkEnabled(module);
                    DartFileListener.updateDependenciesOnDartPackagesLibrary(project, (Condition<Module>)moduleFilter, library);
                }
            }
            finally {
                DartFileListener.setDartPackageRootUpdateScheduledOrInProgress(project, false);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            DumbService.getInstance((Project)project).smartInvokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    @Nullable
    private static Library actualizePackagesLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "actualizePackagesLibrary"));
        }
        DartLibInfo libInfo = DartFileListener.collectPackagesLibraryRoots(project);
        if (libInfo.getLibRootUrls().isEmpty()) {
            return null;
        }
        return DartFileListener.updatePackagesLibraryRoots(project, libInfo);
    }

    @NotNull
    private static DartLibInfo collectPackagesLibraryRoots(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "collectPackagesLibraryRoots"));
        }
        DartLibInfo libInfo = new DartLibInfo(false);
        Collection pubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile pubspecFile : pubspecYamlFiles) {
            Map<String, String> packagesMap;
            Module module;
            VirtualFile dotPackagesFile = pubspecFile.getParent().findChild(".packages");
            Module module2 = module = dotPackagesFile == null ? null : fileIndex.getModuleForFile(dotPackagesFile);
            if (dotPackagesFile == null || dotPackagesFile.isDirectory() || module == null || !DartSdkLibUtil.isDartSdkEnabled(module) || (packagesMap = DotPackagesFileUtil.getPackagesMap(dotPackagesFile)) == null) continue;
            for (Map.Entry<String, String> entry : packagesMap.entrySet()) {
                String packageName = entry.getKey();
                String packagePath = entry.getValue();
                if (!DartFileListener.isPathOutsideProjectContent(fileIndex, packagePath)) continue;
                libInfo.addPackage(packageName, packagePath);
            }
        }
        DartLibInfo dartLibInfo = libInfo;
        if (dartLibInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartFileListener", "collectPackagesLibraryRoots"));
        }
        return dartLibInfo;
    }

    @NotNull
    public static Library updatePackagesLibraryRoots(@NotNull Project project, @NotNull DartLibInfo libInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "updatePackagesLibraryRoots"));
        }
        if (libInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libInfo", "com/jetbrains/lang/dart/DartFileListener", "updatePackagesLibraryRoots"));
        }
        LibraryTable projectLibraryTable = ProjectLibraryTable.getInstance((Project)project);
        Library existingLibrary = projectLibraryTable.getLibraryByName("Dart Packages");
        Library library = existingLibrary != null ? existingLibrary : (Library)ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "lambda$updatePackagesLibraryRoots$2"));
            }
            LibraryTable.ModifiableModel libTableModel = ProjectLibraryTable.getInstance((Project)project).getModifiableModel();
            Library lib = libTableModel.createLibrary("Dart Packages", DartPackagesLibraryType.LIBRARY_KIND);
            libTableModel.commit();
            return lib;
        });
        String[] existingUrls = library.getUrls(OrderRootType.CLASSES);
        Set<String> libRootUrls = libInfo.getLibRootUrls();
        if (!libInfo.isProjectWithoutPubspec() && DartFileListener.isBrokenPackageMap(((LibraryEx)library).getProperties()) || existingUrls.length != libRootUrls.size() || !libRootUrls.containsAll(Arrays.asList(existingUrls))) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (libInfo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libInfo", "com/jetbrains/lang/dart/DartFileListener", "lambda$updatePackagesLibraryRoots$3"));
                }
                LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
                for (String url : existingUrls) {
                    model.removeRoot(url, OrderRootType.CLASSES);
                }
                for (String url : libRootUrls) {
                    model.addRoot(url, OrderRootType.CLASSES);
                }
                DartPackagesLibraryProperties libraryProperties = new DartPackagesLibraryProperties();
                libraryProperties.setPackageNameToDirsMap(libInfo.getPackagesMap());
                model.setProperties((LibraryProperties)libraryProperties);
                model.commit();
            });
        }
        Library library2 = library;
        if (library2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartFileListener", "updatePackagesLibraryRoots"));
        }
        return library2;
    }

    private static boolean isBrokenPackageMap(@Nullable LibraryProperties properties) {
        if (!(properties instanceof DartPackagesLibraryProperties)) {
            return true;
        }
        for (Map.Entry<String, List<String>> entry : ((DartPackagesLibraryProperties)properties).getPackageNameToDirsMap().entrySet()) {
            if (entry != null && entry.getKey() != null && entry.getValue() != null) continue;
            return true;
        }
        return false;
    }

    private static void removeDartPackagesLibraryAndDependencies(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "removeDartPackagesLibraryAndDependencies"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            DartFileListener.removeDependencyOnDartPackagesLibrary(module);
        }
        Library library = ProjectLibraryTable.getInstance((Project)project).getLibraryByName("Dart Packages");
        if (library != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "lambda$removeDartPackagesLibraryAndDependencies$4"));
                }
                ProjectLibraryTable.getInstance((Project)project).removeLibrary(library);
            });
        }
    }

    public static void updateDependenciesOnDartPackagesLibrary(@NotNull Project project, @NotNull Condition<Module> moduleFilter, @NotNull Library library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartFileListener", "updateDependenciesOnDartPackagesLibrary"));
        }
        if (moduleFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFilter", "com/jetbrains/lang/dart/DartFileListener", "updateDependenciesOnDartPackagesLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/jetbrains/lang/dart/DartFileListener", "updateDependenciesOnDartPackagesLibrary"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (moduleFilter.value((Object)module)) {
                DartFileListener.addDependencyOnDartPackagesLibrary(module, library);
                continue;
            }
            DartFileListener.removeDependencyOnDartPackagesLibrary(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDependencyOnDartPackagesLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/DartFileListener", "removeDependencyOnDartPackagesLibrary"));
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                modifiableModel.removeOrderEntry(orderEntry);
            }
            if (modifiableModel.isChanged()) {
                ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
            }
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDependencyOnDartPackagesLibrary(@NotNull Module module, @NotNull Library library) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/DartFileListener", "addDependencyOnDartPackagesLibrary"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/jetbrains/lang/dart/DartFileListener", "addDependencyOnDartPackagesLibrary"));
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        try {
            for (OrderEntry orderEntry : modifiableModel.getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) || !"project".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) || !"Dart Packages".equals(((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
                return;
            }
            modifiableModel.addLibraryEntry(library);
            ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit());
        }
        finally {
            if (!modifiableModel.isDisposed()) {
                modifiableModel.dispose();
            }
        }
    }

    private static boolean isPathOutsideProjectContent(@NotNull ProjectFileIndex fileIndex, @NotNull String path) {
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/jetbrains/lang/dart/DartFileListener", "isPathOutsideProjectContent"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/lang/dart/DartFileListener", "isPathOutsideProjectContent"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && path.contains("/pub/global/cache/")) {
            return true;
        }
        while (!path.isEmpty()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file == null) {
                path = PathUtil.getParentPath((String)path);
                continue;
            }
            return !fileIndex.isInContent(file);
        }
        return false;
    }

    public static class DartLibInfo {
        private final boolean myProjectWithoutPubspec;
        private final Set<String> myLibRootUrls = new TreeSet<String>();
        private final Map<String, List<String>> myPackagesMap = new TreeMap<String, List<String>>();

        public DartLibInfo(boolean projectWithoutPubspec) {
            this.myProjectWithoutPubspec = projectWithoutPubspec;
        }

        private void addPackage(@NotNull String packageName, @NotNull String packagePath) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/lang/dart/DartFileListener$DartLibInfo", "addPackage"));
            }
            if (packagePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePath", "com/jetbrains/lang/dart/DartFileListener$DartLibInfo", "addPackage"));
            }
            this.myLibRootUrls.add(VfsUtilCore.pathToUrl((String)packagePath));
            SmartList paths = this.myPackagesMap.get(packageName);
            if (paths == null) {
                paths = new SmartList();
                this.myPackagesMap.put(packageName, (List<String>)paths);
            }
            if (!paths.contains(packagePath)) {
                paths.add(packagePath);
            }
        }

        public void addRoots(Collection<String> dirPaths) {
            for (String path : dirPaths) {
                this.myLibRootUrls.add(VfsUtilCore.pathToUrl((String)path));
            }
        }

        public boolean isProjectWithoutPubspec() {
            return this.myProjectWithoutPubspec;
        }

        public Set<String> getLibRootUrls() {
            return this.myLibRootUrls;
        }

        public Map<String, List<String>> getPackagesMap() {
            return this.myPackagesMap;
        }
    }
}

