/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.dart.DartParser;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.lexer.DartLexer;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.impl.DartDocCommentImpl;
import com.jetbrains.lang.dart.psi.impl.DartEmbeddedContentImpl;
import org.jetbrains.annotations.NotNull;

public class DartParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        DartLexer dartLexer = new DartLexer();
        if (dartLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "createLexer"));
        }
        return dartLexer;
    }

    public PsiParser createParser(Project project) {
        return new DartParser();
    }

    public IFileElementType getFileNodeType() {
        return DartTokenTypesSets.DART_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = DartTokenTypesSets.WHITE_SPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = DartTokenTypesSets.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.RAW_SINGLE_QUOTED_STRING, DartTokenTypes.RAW_TRIPLE_QUOTED_STRING, DartTokenTypes.OPEN_QUOTE, DartTokenTypes.CLOSING_QUOTE, DartTokenTypes.REGULAR_STRING_PART});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == DartTokenTypesSets.EMBEDDED_CONTENT) {
            DartEmbeddedContentImpl dartEmbeddedContentImpl = new DartEmbeddedContentImpl(node);
            if (dartEmbeddedContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "createElement"));
            }
            return dartEmbeddedContentImpl;
        }
        if (type == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT) {
            DartDocCommentImpl dartDocCommentImpl = new DartDocCommentImpl(node);
            if (dartDocCommentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "createElement"));
            }
            return dartDocCommentImpl;
        }
        PsiElement psiElement = DartTokenTypes.Factory.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new DartFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

