/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartFileListener;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.runner.client.DartiumUtil;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProjectComponent
extends AbstractProjectComponent {
    private SimpleModificationTracker myProjectRootsModificationTracker;

    protected DartProjectComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartProjectComponent", "<init>"));
        }
        super(project);
        this.myProjectRootsModificationTracker = new SimpleModificationTracker();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new DartFileListener(project), (Disposable)project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                DartProjectComponent.this.myProjectRootsModificationTracker.incModificationCount();
                if (!Registry.is((String)"dart.projects.without.pubspec", (boolean)false)) {
                    DartFileListener.scheduleDartPackageRootsUpdate(DartProjectComponent.this.myProject);
                }
            }
        });
    }

    @NotNull
    public static ModificationTracker getProjectRootsModificationTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartProjectComponent", "getProjectRootsModificationTracker"));
        }
        if (project.isDefault()) {
            ModificationTracker modificationTracker = ModificationTracker.NEVER_CHANGED;
            if (modificationTracker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartProjectComponent", "getProjectRootsModificationTracker"));
            }
            return modificationTracker;
        }
        DartProjectComponent component = (DartProjectComponent)((Object)project.getComponent(DartProjectComponent.class));
        assert (component != null);
        SimpleModificationTracker simpleModificationTracker = component.myProjectRootsModificationTracker;
        if (simpleModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartProjectComponent", "getProjectRootsModificationTracker"));
        }
        return simpleModificationTracker;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            this.removeGlobalDartSdkLib();
            this.convertOrderEntriesTargetingGlobalDartSdkLib();
            DartiumUtil.resetDartiumFlags();
            Collection pubspecYamlFiles = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
            for (VirtualFile pubspecYamlFile : pubspecYamlFiles) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)pubspecYamlFile, (Project)this.myProject);
                if (module == null || !FileTypeIndex.containsFileOfType((FileType)DartFileType.INSTANCE, (GlobalSearchScope)module.getModuleContentScope())) continue;
                DartProjectComponent.excludeBuildAndPackagesFolders(module, pubspecYamlFile);
            }
        });
    }

    private void removeGlobalDartSdkLib() {
        for (Library library : ApplicationLibraryTable.getApplicationTable().getLibraries()) {
            if (!"Dart SDK".equals(library.getName())) continue;
            DartSdk oldGlobalSdk = DartSdk.getSdkByLibrary(library);
            if (oldGlobalSdk != null) {
                DartSdkUtil.updateKnownSdkPaths(this.myProject, oldGlobalSdk.getHomePath());
            }
            ApplicationManager.getApplication().runWriteAction(() -> ApplicationLibraryTable.getApplicationTable().removeLibrary(library));
            return;
        }
    }

    private void convertOrderEntriesTargetingGlobalDartSdkLib() {
        DartSdk correctSdk = DartSdk.getDartSdk(this.myProject);
        if (correctSdk != null) {
            return;
        }
        if (!this.hasIncorrectModuleDependencies()) {
            return;
        }
        String sdkPath = DartSdkUtil.getFirstKnownDartSdkPath();
        if (sdkPath == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            DartSdkLibUtil.ensureDartSdkConfigured(this.myProject, sdkPath);
            SmartList modelsToCommit = new SmartList();
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                boolean hasCorrectDependency = false;
                boolean needsCorrectDependency = false;
                SmartList orderEntriesToRemove = new SmartList();
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (DartProjectComponent.isOldGlobalDartSdkLibEntry(orderEntry)) {
                        needsCorrectDependency = true;
                        orderEntriesToRemove.add(orderEntry);
                        continue;
                    }
                    if (!DartSdkLibUtil.isDartSdkOrderEntry(orderEntry)) continue;
                    hasCorrectDependency = true;
                }
                if (needsCorrectDependency && !hasCorrectDependency || !orderEntriesToRemove.isEmpty()) {
                    if (needsCorrectDependency && !hasCorrectDependency) {
                        model.addInvalidLibrary("Dart SDK", "project");
                    }
                    for (OrderEntry entry : orderEntriesToRemove) {
                        model.removeOrderEntry(entry);
                    }
                    modelsToCommit.add(model);
                    continue;
                }
                model.dispose();
            }
            DartProjectComponent.commitModifiableModels(this.myProject, (Collection<ModifiableRootModel>)modelsToCommit);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commitModifiableModels(@NotNull Project project, @NotNull Collection<ModifiableRootModel> modelsToCommit) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/DartProjectComponent", "commitModifiableModels"));
        }
        if (modelsToCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsToCommit", "com/jetbrains/lang/dart/DartProjectComponent", "commitModifiableModels"));
        }
        if (!modelsToCommit.isEmpty()) {
            try {
                ModifiableModelCommitter.multiCommit(modelsToCommit, (ModifiableModuleModel)ModuleManager.getInstance((Project)project).getModifiableModel());
            }
            finally {
                for (ModifiableRootModel model : modelsToCommit) {
                    if (model.isDisposed()) continue;
                    model.dispose();
                }
            }
        }
    }

    private boolean hasIncorrectModuleDependencies() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!DartProjectComponent.isOldGlobalDartSdkLibEntry(orderEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOldGlobalDartSdkLibEntry(OrderEntry orderEntry) {
        return orderEntry instanceof LibraryOrderEntry && "application".equals(((LibraryOrderEntry)orderEntry).getLibraryLevel()) && "Dart SDK".equals(((LibraryOrderEntry)orderEntry).getLibraryName());
    }

    public static void excludeBuildAndPackagesFolders(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile) {
        VirtualFile contentRoot;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/DartProjectComponent", "excludeBuildAndPackagesFolders"));
        }
        if (pubspecYamlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecYamlFile", "com/jetbrains/lang/dart/DartProjectComponent", "excludeBuildAndPackagesFolders"));
        }
        final VirtualFile root = pubspecYamlFile.getParent();
        VirtualFile virtualFile = contentRoot = root == null ? null : ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(root);
        if (contentRoot == null) {
            return;
        }
        List oldExcludedUrls = ContainerUtil.filter((Object[])ModuleRootManager.getInstance((Module)module).getExcludeRootUrls(), (Condition)new Condition<String>(){
            final String rootUrl;
            {
                this.rootUrl = root.getUrl();
            }

            public boolean value(String url) {
                if (url.equals(this.rootUrl + "/.pub")) {
                    return true;
                }
                if (url.equals(this.rootUrl + "/build")) {
                    return true;
                }
                if (url.equals(this.rootUrl + "/packages")) {
                    return true;
                }
                if (url.startsWith(root + "/packages/")) {
                    return true;
                }
                return url.endsWith("/packages") && (url.startsWith(this.rootUrl + "/bin/") || url.startsWith(this.rootUrl + "/benchmark/") || url.startsWith(this.rootUrl + "/example/") || url.startsWith(this.rootUrl + "/test/") || url.startsWith(this.rootUrl + "/tool/") | url.startsWith(this.rootUrl + "/web/"));
            }
        });
        Set<String> newExcludedUrls = DartProjectComponent.collectFolderUrlsToExclude(module, pubspecYamlFile, true);
        if (oldExcludedUrls.size() != newExcludedUrls.size() || !newExcludedUrls.containsAll(oldExcludedUrls)) {
            ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, (Collection)oldExcludedUrls, newExcludedUrls);
        }
    }

    public static Set<String> collectFolderUrlsToExclude(@NotNull Module module, @NotNull VirtualFile pubspecYamlFile, boolean withDotPubAndBuild) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/DartProjectComponent", "collectFolderUrlsToExclude"));
        }
        if (pubspecYamlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pubspecYamlFile", "com/jetbrains/lang/dart/DartProjectComponent", "collectFolderUrlsToExclude"));
        }
        THashSet newExcludedPackagesUrls = new THashSet();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        VirtualFile root = pubspecYamlFile.getParent();
        if (withDotPubAndBuild) {
            newExcludedPackagesUrls.add((Object)(root.getUrl() + "/.pub"));
            newExcludedPackagesUrls.add((Object)(root.getUrl() + "/build"));
        }
        newExcludedPackagesUrls.add((Object)(root.getUrl() + "/packages"));
        VirtualFile binFolder = root.findChild("bin");
        if (binFolder != null && binFolder.isDirectory() && fileIndex.isInContent(binFolder)) {
            newExcludedPackagesUrls.add((Object)(binFolder.getUrl() + "/packages"));
        }
        DartProjectComponent.appendPackagesFolders((Collection<String>)newExcludedPackagesUrls, root.findChild("benchmark"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)newExcludedPackagesUrls, root.findChild("example"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)newExcludedPackagesUrls, root.findChild("test"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)newExcludedPackagesUrls, root.findChild("tool"), fileIndex);
        DartProjectComponent.appendPackagesFolders((Collection<String>)newExcludedPackagesUrls, root.findChild("web"), fileIndex);
        return newExcludedPackagesUrls;
    }

    private static void appendPackagesFolders(final @NotNull Collection<String> excludedPackagesUrls, @Nullable VirtualFile folder, final @NotNull ProjectFileIndex fileIndex) {
        if (excludedPackagesUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedPackagesUrls", "com/jetbrains/lang/dart/DartProjectComponent", "appendPackagesFolders"));
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/jetbrains/lang/dart/DartProjectComponent", "appendPackagesFolders"));
        }
        if (folder == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/DartProjectComponent$3", "visitFileEx"));
                }
                if (!fileIndex.isInContent(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartProjectComponent$3", "visitFileEx"));
                    }
                    return result;
                }
                if (file.isDirectory()) {
                    if ("packages".equals(file.getName())) {
                        VirtualFileVisitor.Result result = SKIP_CHILDREN;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartProjectComponent$3", "visitFileEx"));
                        }
                        return result;
                    }
                    excludedPackagesUrls.add(file.getUrl() + "/packages");
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/DartProjectComponent$3", "visitFileEx"));
                }
                return result;
            }
        });
    }
}

