/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class DartAnalysisServerMessages {
    public static final Topic<DartAnalysisNotifier> DART_ANALYSIS_TOPIC = Topic.create((String)"dart.analysisBusy", DartAnalysisNotifier.class);

    public static void sendAnalysisStarted(@NotNull Project project, boolean isStarting) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/analyzer/DartAnalysisServerMessages", "sendAnalysisStarted"));
        }
        MessageBus bus = project.getMessageBus();
        DartAnalysisNotifier publisher = (DartAnalysisNotifier)bus.syncPublisher(DART_ANALYSIS_TOPIC);
        if (isStarting) {
            publisher.analysisStarted();
        } else {
            publisher.analysisFinished();
        }
    }

    public static interface DartAnalysisNotifier {
        public void analysisStarted();

        public void analysisFinished();
    }
}

