/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.HighlightRegion;
import org.dartlang.analysis.server.protocol.ImplementedClass;
import org.dartlang.analysis.server.protocol.ImplementedMember;
import org.dartlang.analysis.server.protocol.NavigationRegion;
import org.dartlang.analysis.server.protocol.NavigationTarget;
import org.dartlang.analysis.server.protocol.OverriddenMember;
import org.dartlang.analysis.server.protocol.OverrideMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerData {
    private final DartAnalysisServerService myService;
    private final Map<String, List<DartError>> myErrorData;
    private final Map<String, List<DartHighlightRegion>> myHighlightData;
    private final Map<String, List<DartNavigationRegion>> myNavigationData;
    private final Map<String, List<DartOverrideMember>> myOverrideData;
    private final Map<String, List<DartRegion>> myImplementedClassData;
    private final Map<String, List<DartRegion>> myImplementedMemberData;
    private final Set<String> myFilePathsWithUnsentChanges;
    private final Set<String> myFilePathsWithLostErrorInfo;

    DartServerData(@NotNull DartAnalysisServerService service) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/lang/dart/analyzer/DartServerData", "<init>"));
        }
        this.myErrorData = Collections.synchronizedMap(new THashMap());
        this.myHighlightData = Collections.synchronizedMap(new THashMap());
        this.myNavigationData = Collections.synchronizedMap(new THashMap());
        this.myOverrideData = Collections.synchronizedMap(new THashMap());
        this.myImplementedClassData = Collections.synchronizedMap(new THashMap());
        this.myImplementedMemberData = Collections.synchronizedMap(new THashMap());
        this.myFilePathsWithUnsentChanges = Sets.newConcurrentHashSet();
        this.myFilePathsWithLostErrorInfo = Sets.newConcurrentHashSet();
        this.myService = service;
    }

    boolean isErrorInfoLost(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "isErrorInfoLost"));
        }
        return this.myFilePathsWithLostErrorInfo.contains(filePath);
    }

    boolean computedErrors(@NotNull String filePath, @NotNull List<AnalysisError> errors, boolean restartHighlighting) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedErrors"));
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return false;
        }
        ArrayList<DartError> newErrors = new ArrayList<DartError>(errors.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (AnalysisError error : errors) {
            int offset = this.myService.getConvertedOffset(file, error.getLocation().getOffset());
            int length = this.myService.getConvertedOffset(file, error.getLocation().getOffset() + error.getLocation().getLength()) - offset;
            newErrors.add(new DartError(error, offset, length));
        }
        this.myFilePathsWithLostErrorInfo.remove(filePath);
        this.myErrorData.put(filePath, newErrors);
        if (restartHighlighting) {
            this.forceFileAnnotation(file, false);
        }
        return true;
    }

    void computedHighlights(@NotNull String filePath, @NotNull List<HighlightRegion> regions) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedHighlights"));
        }
        if (regions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedHighlights"));
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartHighlightRegion> newRegions = new ArrayList<DartHighlightRegion>(regions.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (HighlightRegion region : regions) {
            if (region.getLength() <= 0) continue;
            int offset = this.myService.getConvertedOffset(file, region.getOffset());
            int length = this.myService.getConvertedOffset(file, region.getOffset() + region.getLength()) - offset;
            newRegions.add(new DartHighlightRegion(offset, length, region.getType()));
        }
        this.myHighlightData.put(filePath, newRegions);
        this.forceFileAnnotation(file, false);
    }

    void computedNavigation(@NotNull String filePath, @NotNull List<NavigationRegion> regions) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedNavigation"));
        }
        if (regions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedNavigation"));
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartNavigationRegion> newRegions = new ArrayList<DartNavigationRegion>(regions.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (NavigationRegion region : regions) {
            if (region.getLength() <= 0) continue;
            DartNavigationRegion dartNavigationRegion = DartServerData.createDartNavigationRegion(this.myService, file, region);
            newRegions.add(dartNavigationRegion);
        }
        this.myNavigationData.put(filePath, newRegions);
        this.forceFileAnnotation(file, true);
    }

    @NotNull
    static DartNavigationRegion createDartNavigationRegion(@NotNull DartAnalysisServerService service, @Nullable VirtualFile file, @NotNull NavigationRegion region) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/jetbrains/lang/dart/analyzer/DartServerData", "createDartNavigationRegion"));
        }
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/jetbrains/lang/dart/analyzer/DartServerData", "createDartNavigationRegion"));
        }
        int offset = service.getConvertedOffset(file, region.getOffset());
        int length = service.getConvertedOffset(file, region.getOffset() + region.getLength()) - offset;
        SmartList targets = new SmartList();
        for (NavigationTarget target : region.getTargetObjects()) {
            targets.add((Object)new DartNavigationTarget(target));
        }
        DartNavigationRegion dartNavigationRegion = new DartNavigationRegion(offset, length, (List<DartNavigationTarget>)targets);
        if (dartNavigationRegion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "createDartNavigationRegion"));
        }
        return dartNavigationRegion;
    }

    void computedOverrides(@NotNull String filePath, @NotNull List<OverrideMember> overrides) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedOverrides"));
        }
        if (overrides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrides", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedOverrides"));
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        ArrayList<DartOverrideMember> newOverrides = new ArrayList<DartOverrideMember>(overrides.size());
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        for (OverrideMember override : overrides) {
            if (override.getLength() <= 0) continue;
            int offset = this.myService.getConvertedOffset(file, override.getOffset());
            int length = this.myService.getConvertedOffset(file, override.getOffset() + override.getLength()) - offset;
            newOverrides.add(new DartOverrideMember(offset, length, override.getSuperclassMember(), override.getInterfaceMembers()));
        }
        this.myOverrideData.put(filePath, newOverrides);
        this.forceFileAnnotation(file, false);
    }

    void computedImplemented(@NotNull String filePath, @NotNull List<ImplementedClass> implementedClasses, @NotNull List<ImplementedMember> implementedMembers) {
        boolean bl;
        List<DartRegion> oldMembers;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedImplemented"));
        }
        if (implementedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementedClasses", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedImplemented"));
        }
        if (implementedMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementedMembers", "com/jetbrains/lang/dart/analyzer/DartServerData", "computedImplemented"));
        }
        if (this.myFilePathsWithUnsentChanges.contains(filePath)) {
            return;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        ArrayList<DartRegion> newImplementedClasses = new ArrayList<DartRegion>(implementedClasses.size());
        for (ImplementedClass implementedClass : implementedClasses) {
            int offset = this.myService.getConvertedOffset(file, implementedClass.getOffset());
            int length = this.myService.getConvertedOffset(file, implementedClass.getOffset() + implementedClass.getLength()) - offset;
            newImplementedClasses.add(new DartRegion(offset, length));
        }
        ArrayList<DartRegion> newImplementedMembers = new ArrayList<DartRegion>(implementedMembers.size());
        for (ImplementedMember implementedMember : implementedMembers) {
            int offset = this.myService.getConvertedOffset(file, implementedMember.getOffset());
            int length = this.myService.getConvertedOffset(file, implementedMember.getOffset() + implementedMember.getLength()) - offset;
            newImplementedMembers.add(new DartRegion(offset, length));
        }
        boolean bl2 = false;
        List<DartRegion> oldClasses = this.myImplementedClassData.get(filePath);
        if (oldClasses == null || !oldClasses.equals(newImplementedClasses)) {
            boolean bl3 = true;
            this.myImplementedClassData.put(filePath, newImplementedClasses);
        }
        if ((oldMembers = this.myImplementedMemberData.get(filePath)) == null || !oldMembers.equals(newImplementedMembers)) {
            bl = true;
            this.myImplementedMemberData.put(filePath, newImplementedMembers);
        }
        if (bl) {
            this.forceFileAnnotation(file, false);
        }
    }

    @NotNull
    List<DartError> getErrors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getErrors"));
        }
        List<DartError> errors = this.myErrorData.get(file.getPath());
        List<DartError> list = errors != null ? errors : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getErrors"));
        }
        return list;
    }

    @NotNull
    List<DartHighlightRegion> getHighlight(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getHighlight"));
        }
        List<DartHighlightRegion> regions = this.myHighlightData.get(file.getPath());
        List<DartHighlightRegion> list = regions != null ? regions : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getHighlight"));
        }
        return list;
    }

    @NotNull
    List<DartNavigationRegion> getNavigation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getNavigation"));
        }
        List<DartNavigationRegion> regions = this.myNavigationData.get(file.getPath());
        List<DartNavigationRegion> list = regions != null ? regions : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getNavigation"));
        }
        return list;
    }

    @NotNull
    List<DartOverrideMember> getOverrideMembers(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getOverrideMembers"));
        }
        List<DartOverrideMember> regions = this.myOverrideData.get(file.getPath());
        List<DartOverrideMember> list = regions != null ? regions : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getOverrideMembers"));
        }
        return list;
    }

    @NotNull
    List<DartRegion> getImplementedClasses(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getImplementedClasses"));
        }
        List<DartRegion> classes = this.myImplementedClassData.get(file.getPath());
        List<DartRegion> list = classes != null ? classes : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getImplementedClasses"));
        }
        return list;
    }

    @NotNull
    List<DartRegion> getImplementedMembers(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "getImplementedMembers"));
        }
        List<DartRegion> classes = this.myImplementedMemberData.get(file.getPath());
        List<DartRegion> list = classes != null ? classes : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/DartServerData", "getImplementedMembers"));
        }
        return list;
    }

    private void forceFileAnnotation(@Nullable VirtualFile file, boolean clearCache) {
        if (file != null) {
            Project project = this.myService.getProject();
            if (clearCache) {
                ResolveCache.getInstance((Project)project).clearCache(true);
            }
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project).restart(), ModalityState.NON_MODAL, project.getDisposed());
        }
    }

    void onFilesContentUpdated() {
        this.myFilePathsWithUnsentChanges.clear();
    }

    void onFileClosed(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/DartServerData", "onFileClosed"));
        }
        this.myHighlightData.remove(file.getPath());
        this.myNavigationData.remove(file.getPath());
        this.myOverrideData.remove(file.getPath());
        this.myImplementedClassData.remove(file.getPath());
        this.myImplementedMemberData.remove(file.getPath());
    }

    void onFlushedResults(@NotNull List<String> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/jetbrains/lang/dart/analyzer/DartServerData", "onFlushedResults"));
        }
        if (!this.myErrorData.isEmpty()) {
            for (String path : filePaths) {
                this.myErrorData.remove(path);
            }
        }
        if (!this.myHighlightData.isEmpty()) {
            for (String path : filePaths) {
                this.myHighlightData.remove(path);
            }
        }
        if (!this.myNavigationData.isEmpty()) {
            for (String path : filePaths) {
                this.myNavigationData.remove(path);
            }
        }
        if (!this.myOverrideData.isEmpty()) {
            for (String path : filePaths) {
                this.myOverrideData.remove(path);
            }
        }
        if (!this.myImplementedClassData.isEmpty()) {
            for (String path : filePaths) {
                this.myImplementedClassData.remove(path);
            }
        }
        if (!this.myImplementedMemberData.isEmpty()) {
            for (String path : filePaths) {
                this.myImplementedMemberData.remove(path);
            }
        }
    }

    void clearData() {
        this.myErrorData.clear();
        this.myHighlightData.clear();
        this.myNavigationData.clear();
        this.myOverrideData.clear();
        this.myImplementedClassData.clear();
        this.myImplementedMemberData.clear();
    }

    void onDocumentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/analyzer/DartServerData", "onDocumentChanged"));
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(e.getDocument());
        if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) {
            return;
        }
        String filePath = file.getPath();
        this.myFilePathsWithUnsentChanges.add(filePath);
        boolean someRegionDeleted = DartServerData.updateRegionsDeletingTouched(filePath, this.myErrorData.get(filePath), e);
        if (someRegionDeleted) {
            this.myFilePathsWithLostErrorInfo.add(filePath);
        }
        DartServerData.updateRegionsUpdatingTouched(this.myHighlightData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myNavigationData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myOverrideData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myImplementedClassData.get(filePath), e);
        DartServerData.updateRegionsDeletingTouched(filePath, this.myImplementedMemberData.get(filePath), e);
    }

    private static boolean updateRegionsDeletingTouched(@NotNull String filePath, @Nullable List<? extends DartRegion> regions, @NotNull DocumentEvent e) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/jetbrains/lang/dart/analyzer/DartServerData", "updateRegionsDeletingTouched"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/analyzer/DartServerData", "updateRegionsDeletingTouched"));
        }
        if (regions == null) {
            return false;
        }
        boolean regionDeleted = false;
        int eventOffset = e.getOffset();
        int deltaLength = e.getNewLength() - e.getOldLength();
        Iterator<? extends DartRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            DartRegion region = iterator.next();
            if (region instanceof DartNavigationRegion) {
                for (DartNavigationTarget target : ((DartNavigationRegion)region).getTargets()) {
                    if (!target.myFile.equals(filePath) || target.myConvertedOffset < eventOffset) continue;
                    DartNavigationTarget dartNavigationTarget = target;
                    dartNavigationTarget.myConvertedOffset = dartNavigationTarget.myConvertedOffset + deltaLength;
                }
            }
            if (deltaLength > 0) {
                if (eventOffset <= region.myOffset) {
                    region.myOffset += deltaLength;
                    continue;
                }
                if (region.myOffset >= eventOffset || eventOffset >= region.myOffset + region.myLength) continue;
                iterator.remove();
                regionDeleted = true;
                continue;
            }
            if (deltaLength >= 0) continue;
            int eventRightOffset = eventOffset - deltaLength;
            if (eventRightOffset <= region.myOffset) {
                region.myOffset += deltaLength;
                continue;
            }
            if (eventOffset >= region.myOffset + region.myLength) continue;
            iterator.remove();
            regionDeleted = true;
        }
        return regionDeleted;
    }

    private static void updateRegionsUpdatingTouched(@Nullable List<? extends DartRegion> regions, @NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/analyzer/DartServerData", "updateRegionsUpdatingTouched"));
        }
        if (regions == null) {
            return;
        }
        int eventOffset = e.getOffset();
        int deltaLength = e.getNewLength() - e.getOldLength();
        Iterator<? extends DartRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            DartRegion region = iterator.next();
            if (deltaLength > 0) {
                if (eventOffset <= region.myOffset) {
                    region.myOffset += deltaLength;
                    continue;
                }
                if (region.myOffset >= eventOffset || eventOffset >= region.myOffset + region.myLength) continue;
                region.myLength += deltaLength;
                continue;
            }
            if (deltaLength >= 0) continue;
            int eventRightOffset = eventOffset - deltaLength;
            int regionRightOffset = region.myOffset + region.myLength;
            if (eventRightOffset <= region.myOffset) {
                region.myOffset += deltaLength;
                continue;
            }
            if (region.myOffset <= eventOffset && eventRightOffset <= regionRightOffset && region.myLength != -deltaLength) {
                region.myLength += deltaLength;
                continue;
            }
            if (eventOffset >= regionRightOffset) continue;
            iterator.remove();
        }
    }

    public static class DartOverrideMember
    extends DartRegion {
        @Nullable
        private final OverriddenMember mySuperclassMember;
        @Nullable
        private final List<OverriddenMember> myInterfaceMembers;

        private DartOverrideMember(int offset, int length, @Nullable OverriddenMember superclassMember, @Nullable List<OverriddenMember> interfaceMembers) {
            super(offset, length);
            this.mySuperclassMember = superclassMember;
            this.myInterfaceMembers = interfaceMembers;
        }

        @Nullable
        public OverriddenMember getSuperclassMember() {
            return this.mySuperclassMember;
        }

        @Nullable
        public List<OverriddenMember> getInterfaceMembers() {
            return this.myInterfaceMembers;
        }
    }

    public static class DartNavigationTarget {
        private final String myFile;
        private final int myOriginalOffset;
        private final String myKind;
        private int myConvertedOffset;

        private DartNavigationTarget(@NotNull NavigationTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/lang/dart/analyzer/DartServerData$DartNavigationTarget", "<init>"));
            }
            this.myConvertedOffset = -1;
            this.myFile = FileUtil.toSystemIndependentName((String)target.getFile().trim()).intern();
            this.myOriginalOffset = target.getOffset();
            this.myKind = target.getKind().intern();
        }

        public String getFile() {
            return this.myFile;
        }

        public int getOffset(@NotNull Project project, @Nullable VirtualFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/analyzer/DartServerData$DartNavigationTarget", "getOffset"));
            }
            if (this.myConvertedOffset == -1) {
                this.myConvertedOffset = DartAnalysisServerService.getInstance(project).getConvertedOffset(file, this.myOriginalOffset);
            }
            return this.myConvertedOffset;
        }

        public String getKind() {
            return this.myKind;
        }
    }

    public static class DartNavigationRegion
    extends DartRegion {
        private final List<DartNavigationTarget> myTargets;

        DartNavigationRegion(int offset, int length, @NotNull List<DartNavigationTarget> targets) {
            if (targets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/lang/dart/analyzer/DartServerData$DartNavigationRegion", "<init>"));
            }
            super(offset, length);
            this.myTargets = targets;
        }

        public String toString() {
            return "DartNavigationRegion(" + this.myOffset + ", " + this.myLength + ")";
        }

        public List<DartNavigationTarget> getTargets() {
            return this.myTargets;
        }
    }

    public static class DartError
    extends DartRegion {
        private final String myAnalysisErrorFileSD;
        private final String mySeverity;
        @Nullable
        private final String myCode;
        private final String myMessage;

        private DartError(@NotNull AnalysisError error, int correctedOffset, int correctedLength) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/lang/dart/analyzer/DartServerData$DartError", "<init>"));
            }
            super(correctedOffset, correctedLength);
            this.myAnalysisErrorFileSD = error.getLocation().getFile().intern();
            this.mySeverity = error.getSeverity().intern();
            this.myCode = error.getCode() == null ? null : error.getCode().intern();
            this.myMessage = error.getMessage();
        }

        public String getAnalysisErrorFileSD() {
            return this.myAnalysisErrorFileSD;
        }

        public String getSeverity() {
            return this.mySeverity;
        }

        @Nullable
        public String getCode() {
            return this.myCode;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }

    public static class DartHighlightRegion
    extends DartRegion {
        private final String type;

        private DartHighlightRegion(int offset, int length, @NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/lang/dart/analyzer/DartServerData$DartHighlightRegion", "<init>"));
            }
            super(offset, length);
            this.type = type.intern();
        }

        public String getType() {
            return this.type;
        }
    }

    public static class DartRegion {
        protected int myOffset;
        protected int myLength;

        DartRegion(int offset, int length) {
            this.myOffset = offset;
            this.myLength = length;
        }

        public final int getOffset() {
            return this.myOffset;
        }

        public final int getLength() {
            return this.myLength;
        }

        public boolean equals(Object o) {
            return o instanceof DartRegion && this.myOffset == ((DartRegion)o).myOffset && this.myLength == ((DartRegion)o).myLength;
        }

        public int hashCode() {
            return this.myOffset * 31 + this.myLength;
        }
    }
}

