/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.analyzer;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileOffsetsManager {
    private final Map<VirtualFile, LineOffsets> myLineOffsetsMap = new THashMap();

    @NotNull
    public static FileOffsetsManager getInstance() {
        FileOffsetsManager fileOffsetsManager = (FileOffsetsManager)ServiceManager.getService(FileOffsetsManager.class);
        if (fileOffsetsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getInstance"));
        }
        return fileOffsetsManager;
    }

    public int getConvertedOffset(@NotNull VirtualFile file, int originalOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getConvertedOffset"));
        }
        LineOffsets offsets = this.getLineOffsets(file);
        if (offsets.myLineOffsetsAreTheSame) {
            return originalOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myOriginalLineOffsets, offsets.myConvertedLineOffsets, originalOffset);
    }

    public int getOriginalOffset(@NotNull VirtualFile file, int convertedOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getOriginalOffset"));
        }
        LineOffsets offsets = this.getLineOffsets(file);
        if (offsets.myLineOffsetsAreTheSame) {
            return convertedOffset;
        }
        return FileOffsetsManager.getCorrespondingOffset(offsets.myConvertedLineOffsets, offsets.myOriginalLineOffsets, convertedOffset);
    }

    private static int getCorrespondingOffset(int[] offsets1, int[] offsets2, int offset1) {
        int line = Arrays.binarySearch(offsets1, offset1);
        if (line < 0) {
            line = -line - 2;
        }
        try {
            return offsets2[line] + offset1 - offsets1[line];
        }
        catch (Exception e) {
            return offset1;
        }
    }

    @NotNull
    private LineOffsets getLineOffsets(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getLineOffsets"));
        }
        LineOffsets offsets = this.myLineOffsetsMap.get(file);
        if (offsets != null && file.getModificationStamp() == offsets.myFileModificationStamp) {
            LineOffsets lineOffsets = offsets;
            if (lineOffsets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getLineOffsets"));
            }
            return lineOffsets;
        }
        offsets = FileOffsetsManager.loadLineOffsets(file);
        this.myLineOffsetsMap.put(file, offsets);
        LineOffsets lineOffsets = offsets;
        if (lineOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "getLineOffsets"));
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull VirtualFile file) {
        LineOffsets lineOffsets;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        assert (!file.getFileType().isBinary());
        try {
            byte[] bytes = file.contentsToByteArray();
            Charset charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)file, (byte[])bytes);
            byte[] bom = file.getBOM();
            int bomLength = bom == null ? 0 : bom.length;
            lineOffsets = FileOffsetsManager.loadLineOffsets(bytes, charset, bomLength, file.getModificationStamp());
        }
        catch (IOException e) {
            LineOffsets lineOffsets2 = new LineOffsets(file.getModificationStamp(), new int[]{0}, new int[]{0});
            if (lineOffsets2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
            }
            return lineOffsets2;
        }
        if (lineOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull byte[] bytes, @NotNull Charset charset, int startOffset, long modificationStamp) {
        CharBuffer charBuffer;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        try {
            charBuffer = charset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        LineOffsets lineOffsets = FileOffsetsManager.loadLineOffsets(charBuffer, modificationStamp);
        if (lineOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        return lineOffsets;
    }

    @NotNull
    private static LineOffsets loadLineOffsets(@NotNull CharBuffer buffer, long modificationStamp) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        int dst = 0;
        int prev = 32;
        int crlfCount = 0;
        IntArrayList originalLineOffsets = new IntArrayList();
        IntArrayList convertedLineOffsets = new IntArrayList();
        originalLineOffsets.add(0);
        convertedLineOffsets.add(0);
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        originalLineOffsets.set(originalLineOffsets.size() - 1, dst + ++crlfCount);
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    originalLineOffsets.add(dst + crlfCount);
                    convertedLineOffsets.add(dst);
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        LineOffsets lineOffsets = new LineOffsets(modificationStamp, originalLineOffsets.toArray(), convertedLineOffsets.toArray());
        if (lineOffsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager", "loadLineOffsets"));
        }
        return lineOffsets;
    }

    private static class LineOffsets {
        private final long myFileModificationStamp;
        private final int[] myOriginalLineOffsets;
        private final int[] myConvertedLineOffsets;
        private final boolean myLineOffsetsAreTheSame;

        /*
         * WARNING - void declaration
         */
        public LineOffsets(long modificationStamp, @NotNull int[] originalLineOffsets, @NotNull int[] nArray) {
            void convertedLineOffsets;
            if (originalLineOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLineOffsets", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager$LineOffsets", "<init>"));
            }
            if (nArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertedLineOffsets", "com/jetbrains/lang/dart/analyzer/FileOffsetsManager$LineOffsets", "<init>"));
            }
            assert (originalLineOffsets.length > 0 && ((void)convertedLineOffsets).length > 0 && originalLineOffsets.length == ((void)convertedLineOffsets).length) : originalLineOffsets.length + " " + ((void)convertedLineOffsets).length;
            this.myFileModificationStamp = modificationStamp;
            this.myOriginalLineOffsets = originalLineOffsets;
            this.myConvertedLineOffsets = convertedLineOffsets;
            this.myLineOffsetsAreTheSame = originalLineOffsets[originalLineOffsets.length - 1] == convertedLineOffsets[((void)convertedLineOffsets).length - 1];
        }
    }
}

