/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.ChangeTarget;
import com.jetbrains.lang.dart.assists.DartLookupExpression;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dartlang.analysis.server.protocol.LinkedEditGroup;
import org.dartlang.analysis.server.protocol.Position;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssistUtils {
    public static boolean applyFileEdit(@NotNull Project project, @NotNull SourceFileEdit fileEdit) {
        Document document;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "applyFileEdit"));
        }
        if (fileEdit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEdit", "com/jetbrains/lang/dart/assists/AssistUtils", "applyFileEdit"));
        }
        VirtualFile file = AssistUtils.findVirtualFile(fileEdit);
        Document document2 = document = file == null ? null : FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        long initialModStamp = document.getModificationStamp();
        AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), Collections.emptySet());
        return document.getModificationStamp() != initialModStamp;
    }

    public static void applySourceChange(@NotNull Project project, @NotNull SourceChange sourceChange, boolean withLinkedEdits) throws DartSourceEditException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceChange"));
        }
        if (sourceChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceChange"));
        }
        AssistUtils.applySourceChange(project, sourceChange, withLinkedEdits, Collections.emptySet());
    }

    public static void applySourceChange(@NotNull Project project, @NotNull SourceChange sourceChange, boolean withLinkedEdits, @NotNull Set<String> excludedIds) throws DartSourceEditException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceChange"));
        }
        if (sourceChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceChange"));
        }
        if (excludedIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedIds", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceChange"));
        }
        Map<VirtualFile, SourceFileEdit> changeMap = AssistUtils.getContentFilesChanges(project, sourceChange, excludedIds);
        Set<VirtualFile> files = changeMap.keySet();
        boolean okToWrite = FileModificationService.getInstance().prepareVirtualFilesForWrite(project, files);
        if (!okToWrite) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "lambda$applySourceChange$0"));
            }
            if (sourceChange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "lambda$applySourceChange$0"));
            }
            if (excludedIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedIds", "com/jetbrains/lang/dart/assists/AssistUtils", "lambda$applySourceChange$0"));
            }
            ChangeTarget linkedEditTarget = withLinkedEdits ? AssistUtils.findChangeTarget(project, sourceChange) : null;
            List<SourceEditInfo> sourceEditInfos = null;
            for (Map.Entry entry : changeMap.entrySet()) {
                VirtualFile file = (VirtualFile)entry.getKey();
                SourceFileEdit fileEdit = (SourceFileEdit)entry.getValue();
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) continue;
                List<SourceEditInfo> infos = AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), excludedIds);
                if (linkedEditTarget == null || !linkedEditTarget.virtualFile.equals(file)) continue;
                sourceEditInfos = infos;
            }
            if (withLinkedEdits && sourceEditInfos != null) {
                AssistUtils.runLinkedEdits(project, sourceChange, linkedEditTarget, sourceEditInfos);
            }
        }, sourceChange.getMessage(), null);
    }

    public static List<SourceEditInfo> applySourceEdits(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @NotNull List<SourceEdit> edits, @NotNull Set<String> excludedIds) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceEdits"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceEdits"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceEdits"));
        }
        if (edits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edits", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceEdits"));
        }
        if (excludedIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedIds", "com/jetbrains/lang/dart/assists/AssistUtils", "applySourceEdits"));
        }
        ArrayList<SourceEditInfo> result = new ArrayList<SourceEditInfo>(edits.size());
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        for (SourceEdit edit : edits) {
            if (excludedIds.contains(edit.getId())) continue;
            int offset = service.getConvertedOffset(file, edit.getOffset());
            int length = service.getConvertedOffset(file, edit.getOffset() + edit.getLength()) - offset;
            String replacement = StringUtil.convertLineSeparators((String)edit.getReplacement());
            for (SourceEditInfo info : result) {
                if (info.resultingOriginalOffset <= edit.getOffset()) continue;
                SourceEditInfo sourceEditInfo = info;
                sourceEditInfo.resultingOriginalOffset = sourceEditInfo.resultingOriginalOffset - edit.getLength();
                sourceEditInfo = info;
                sourceEditInfo.resultingOriginalOffset = sourceEditInfo.resultingOriginalOffset + edit.getReplacement().length();
                sourceEditInfo = info;
                sourceEditInfo.resultingConvertedOffset = sourceEditInfo.resultingConvertedOffset - length;
                sourceEditInfo = info;
                sourceEditInfo.resultingConvertedOffset = sourceEditInfo.resultingConvertedOffset + replacement.length();
            }
            result.add(new SourceEditInfo(edit.getOffset(), offset, edit.getLength(), length, edit.getReplacement(), replacement));
            if (length == replacement.length() && replacement.equals(document.getText(TextRange.create((int)offset, (int)(offset + length))))) continue;
            document.replaceString(offset, offset + length, (CharSequence)replacement);
        }
        return result;
    }

    @NotNull
    public static Map<VirtualFile, SourceFileEdit> getContentFilesChanges(@NotNull Project project, @NotNull SourceChange sourceChange, @NotNull Set<String> excludedIds) throws DartSourceEditException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "getContentFilesChanges"));
        }
        if (sourceChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "getContentFilesChanges"));
        }
        if (excludedIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedIds", "com/jetbrains/lang/dart/assists/AssistUtils", "getContentFilesChanges"));
        }
        HashMap map = Maps.newHashMap();
        List<SourceFileEdit> fileEdits = sourceChange.getEdits();
        for (SourceFileEdit fileEdit : fileEdits) {
            boolean allEditsExcluded = true;
            for (SourceEdit edit : fileEdit.getEdits()) {
                if (excludedIds.contains(edit.getId())) continue;
                allEditsExcluded = false;
                break;
            }
            if (allEditsExcluded) continue;
            VirtualFile file = AssistUtils.findVirtualFile(fileEdit);
            if (file == null) {
                throw new DartSourceEditException("Failed to edit file, file not found: " + fileEdit.getFile());
            }
            if (!AssistUtils.isInContent(project, file)) {
                throw new DartSourceEditException("Can't edit file outside of the project content: " + fileEdit.getFile());
            }
            map.put(file, fileEdit);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/assists/AssistUtils", "getContentFilesChanges"));
        }
        return hashMap;
    }

    @Nullable
    private static ChangeTarget findChangeTarget(@NotNull Project project, @NotNull SourceChange sourceChange) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "findChangeTarget"));
        }
        if (sourceChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "findChangeTarget"));
        }
        for (LinkedEditGroup group : sourceChange.getLinkedEditGroups()) {
            List<Position> positions = group.getPositions();
            if (positions.isEmpty()) continue;
            Position position = positions.get(0);
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)position.getFile()));
            if (virtualFile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return new ChangeTarget(project, virtualFile, psiFile, position.getOffset());
        }
        return null;
    }

    private static int getLinkedEditConvertedOffset(@NotNull Project project, @NotNull VirtualFile file, int linkedEditOffset, @NotNull List<SourceEditInfo> editInfos) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "getLinkedEditConvertedOffset"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/assists/AssistUtils", "getLinkedEditConvertedOffset"));
        }
        if (editInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editInfos", "com/jetbrains/lang/dart/assists/AssistUtils", "getLinkedEditConvertedOffset"));
        }
        for (SourceEditInfo info : editInfos) {
            if (linkedEditOffset < info.resultingOriginalOffset || linkedEditOffset > info.resultingOriginalOffset + info.originalReplacement.length()) continue;
            String substring = info.originalReplacement.substring(0, linkedEditOffset - info.resultingOriginalOffset);
            int crlfCount = StringUtil.getOccurrenceCount((String)substring, (String)"\r\n");
            return info.resultingConvertedOffset + linkedEditOffset - info.resultingOriginalOffset - crlfCount;
        }
        int leOffset = linkedEditOffset;
        for (int i = editInfos.size() - 1; i >= 0; --i) {
            SourceEditInfo info = editInfos.get(i);
            if (linkedEditOffset < info.originalOffset) continue;
            leOffset -= info.originalReplacement.length();
            leOffset += info.originalLength;
        }
        leOffset = DartAnalysisServerService.getInstance(project).getConvertedOffset(file, leOffset);
        for (SourceEditInfo info : editInfos) {
            if (leOffset < info.convertedOffset) continue;
            leOffset -= info.convertedLength;
            leOffset += info.normalizedReplacement.length();
        }
        return leOffset;
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull SourceFileEdit fileEdit) {
        if (fileEdit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEdit", "com/jetbrains/lang/dart/assists/AssistUtils", "findVirtualFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)fileEdit.getFile()));
    }

    private static boolean isInContent(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "isInContent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/assists/AssistUtils", "isInContent"));
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }

    @Nullable
    public static Editor navigate(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "navigate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/assists/AssistUtils", "navigate"));
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, offset);
        descriptor.setScrollType(ScrollType.MAKE_VISIBLE);
        descriptor.navigate(true);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        return fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
    }

    private static void runLinkedEdits(@NotNull Project project, @NotNull SourceChange sourceChange, @NotNull ChangeTarget target, @NotNull List<SourceEditInfo> sourceEditInfos) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/AssistUtils", "runLinkedEdits"));
        }
        if (sourceChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceChange", "com/jetbrains/lang/dart/assists/AssistUtils", "runLinkedEdits"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/lang/dart/assists/AssistUtils", "runLinkedEdits"));
        }
        if (sourceEditInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditInfos", "com/jetbrains/lang/dart/assists/AssistUtils", "runLinkedEdits"));
        }
        int caretOffset = AssistUtils.getLinkedEditConvertedOffset(project, target.virtualFile, target.originalOffset, sourceEditInfos);
        Editor editor = AssistUtils.navigate(project, target.virtualFile, caretOffset);
        if (editor == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)target.psiFile);
        boolean hasTextRanges = false;
        int groupIndex = 0;
        for (LinkedEditGroup group : sourceChange.getLinkedEditGroups()) {
            String mainVar = "group_" + groupIndex++;
            boolean firstPosition = true;
            ++groupIndex;
            for (Position position : group.getPositions()) {
                if (!FileUtil.toSystemIndependentName((String)position.getFile()).equals(target.virtualFile.getPath())) continue;
                hasTextRanges = true;
                int offset = AssistUtils.getLinkedEditConvertedOffset(project, target.virtualFile, position.getOffset(), sourceEditInfos);
                int end = offset + group.getLength();
                TextRange range = new TextRange(offset, end);
                if (firstPosition) {
                    firstPosition = false;
                    String text = editor.getDocument().getText(range);
                    DartLookupExpression expression = new DartLookupExpression(text, group.getSuggestions());
                    builder.replaceRange(range, mainVar, (Expression)expression, true);
                    continue;
                }
                String positionVar = mainVar + "_" + offset;
                builder.replaceElement(range, positionVar, mainVar, false);
            }
        }
        if (hasTextRanges) {
            builder.run(editor, true);
        }
    }

    private static class SourceEditInfo {
        private final int originalOffset;
        private int resultingOriginalOffset;
        private final int convertedOffset;
        private int resultingConvertedOffset;
        private final int originalLength;
        private final int convertedLength;
        private final String originalReplacement;
        private final String normalizedReplacement;

        public SourceEditInfo(int originalOffset, int convertedOffset, int originalLength, int convertedLength, String originalReplacement, String normalizedReplacement) {
            this.originalOffset = originalOffset;
            this.resultingOriginalOffset = originalOffset;
            this.convertedOffset = convertedOffset;
            this.resultingConvertedOffset = convertedOffset;
            this.originalLength = originalLength;
            this.convertedLength = convertedLength;
            this.originalReplacement = originalReplacement;
            this.normalizedReplacement = normalizedReplacement;
        }
    }
}

