/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import com.jetbrains.lang.dart.assists.QuickAssistSet;
import com.jetbrains.lang.dart.psi.DartFile;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartQuickAssistIntention
implements IntentionAction,
Comparable<IntentionAction> {
    @Nullable
    private final QuickAssistSet quickAssistSet;
    private final int index;
    @Nullable
    private SourceChange sourceChange;

    public DartQuickAssistIntention() {
        this.quickAssistSet = null;
        this.index = -1;
    }

    public DartQuickAssistIntention(@NotNull QuickAssistSet quickAssistSet, int index) {
        if (quickAssistSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickAssistSet", "com/jetbrains/lang/dart/assists/DartQuickAssistIntention", "<init>"));
        }
        this.quickAssistSet = quickAssistSet;
        this.index = index;
    }

    @Override
    public int compareTo(IntentionAction o) {
        if (o instanceof DartQuickAssistIntention) {
            DartQuickAssistIntention other = (DartQuickAssistIntention)o;
            return this.index - other.index;
        }
        return 0;
    }

    @NotNull
    public String getFamilyName() {
        String message = DartBundle.message("dart.quick.assist.family.name", new Object[0]);
        String string = this.quickAssistSet == null ? message : "Dart/" + message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/assists/DartQuickAssistIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.sourceChange == null ? "" : this.sourceChange.getMessage();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/assists/DartQuickAssistIntention", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/DartQuickAssistIntention", "invoke"));
        }
        if (this.sourceChange != null) {
            try {
                AssistUtils.applySourceChange(project, this.sourceChange, true);
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/assists/DartQuickAssistIntention", "isAvailable"));
        }
        if (this.quickAssistSet == null || !(file instanceof DartFile)) {
            return false;
        }
        List<SourceChange> sourceChanges = this.quickAssistSet.getQuickAssists(editor, file);
        if (sourceChanges.size() <= this.index) {
            this.sourceChange = null;
            return false;
        }
        this.sourceChange = sourceChanges.get(this.index);
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

