/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.assists;

import com.google.common.collect.Lists;
import com.google.dart.server.utilities.general.ObjectUtilities;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;

public class QuickAssistSet {
    private List<SourceChange> lastSourceChanges = Lists.newArrayList();
    private long lastPsiModificationCount;
    private String lastFilePath;
    private int lastOffset;
    private int lastLength;

    public List<SourceChange> getQuickAssists(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/assists/QuickAssistSet", "getQuickAssists"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/assists/QuickAssistSet", "getQuickAssists"));
        }
        long psiModificationCount = psiFile.getManager().getModificationTracker().getModificationCount();
        String filePath = psiFile.getVirtualFile().getPath();
        Caret currentCaret = editor.getCaretModel().getPrimaryCaret();
        int offset = currentCaret.getSelectionStart();
        int length = currentCaret.getSelectionEnd() - offset;
        if (this.lastPsiModificationCount == psiModificationCount && ObjectUtilities.equals(this.lastFilePath, filePath) && this.lastOffset == offset && this.lastLength == length) {
            return this.lastSourceChanges;
        }
        this.lastFilePath = filePath;
        this.lastOffset = offset;
        this.lastLength = length;
        this.lastPsiModificationCount = psiModificationCount;
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(psiFile.getProject());
        service.updateFilesContent();
        this.lastSourceChanges = service.edit_getAssists(psiFile.getVirtualFile(), offset, length);
        return this.lastSourceChanges;
    }
}

