/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageAnnotator
extends SimpleCoverageAnnotator {
    public DartCoverageAnnotator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "<init>"));
        }
        super(project);
    }

    @NotNull
    public static DartCoverageAnnotator getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "getInstance"));
        }
        DartCoverageAnnotator dartCoverageAnnotator = (DartCoverageAnnotator)((Object)ServiceManager.getService((Project)project, DartCoverageAnnotator.class));
        if (dartCoverageAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "getInstance"));
        }
        return dartCoverageAnnotator;
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "fillInfoForUncoveredFile"));
        }
        return new BaseCoverageAnnotator.FileCoverageInfo();
    }

    @Nullable
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "getLinesCoverageInformationString"));
        }
        if (info.totalLineCount == 0) {
            return null;
        }
        if (info.coveredLineCount == 0) {
            return info instanceof BaseCoverageAnnotator.DirCoverageInfo ? null : "no lines covered";
        }
        if (info.coveredLineCount * 100 < info.totalLineCount) {
            return "<1% lines covered";
        }
        return (int)((double)info.coveredLineCount * 100.0 / (double)info.totalLineCount) + "% lines covered";
    }

    @Nullable
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/lang/dart/coverage/DartCoverageAnnotator", "getFilesCoverageInformationString"));
        }
        if (info.totalFilesCount == 0) {
            return null;
        }
        if (info.coveredFilesCount == 0) {
            return info.coveredFilesCount + " of " + info.totalFilesCount + " files covered";
        }
        return info.coveredFilesCount + " of " + info.totalFilesCount + " files";
    }
}

