/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.lang.dart.coverage.DartFileCoverageData;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageData {
    @Nullable
    private List<DartFileCoverageData> coverage;

    @Nullable
    public List<DartFileCoverageData> getCoverage() {
        return this.coverage;
    }

    public void setCoverage(@Nullable List<DartFileCoverageData> coverage) {
        this.coverage = coverage;
    }

    @NotNull
    public Map<String, SortedMap<Integer, Integer>> getMergedDartFileCoverageData() {
        HashMap mergedCoverageData = new HashMap();
        List<DartFileCoverageData> coverageData = this.getCoverage();
        if (coverageData != null) {
            for (DartFileCoverageData item : coverageData) {
                String source = item.getSource();
                if (source == null) continue;
                if (!mergedCoverageData.containsKey(source)) {
                    mergedCoverageData.put(source, new TreeMap());
                }
                SortedMap fileData = (SortedMap)mergedCoverageData.get(source);
                List<Integer> hits = item.getHits();
                if (hits == null) continue;
                for (int i = 0; i < hits.size(); i += 2) {
                    Integer lineNumber = hits.get(i);
                    Integer hitCount = hits.get(i + 1);
                    if (!fileData.containsKey(lineNumber)) {
                        fileData.put(lineNumber, 0);
                    }
                    fileData.put(lineNumber, (Integer)fileData.get(lineNumber) + hitCount);
                }
            }
        }
        HashMap hashMap = mergedCoverageData;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageData", "getMergedDartFileCoverageData"));
        }
        return hashMap;
    }
}

