/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.coverage.DartCoverageAnnotator;
import com.jetbrains.lang.dart.coverage.DartCoverageEnabledConfiguration;
import com.jetbrains.lang.dart.coverage.DartCoverageSuite;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.psi.DartFile;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageEngine
extends CoverageEngine {
    public static DartCoverageEngine getInstance() {
        return (DartCoverageEngine)((Object)Extensions.findExtension((ExtensionPointName)CoverageEngine.EP_NAME, DartCoverageEngine.class));
    }

    public boolean isApplicableTo(@Nullable RunConfigurationBase conf) {
        return conf instanceof DartCommandLineRunConfiguration;
    }

    public boolean canHavePerTestCoverage(@Nullable RunConfigurationBase conf) {
        return false;
    }

    @NotNull
    public CoverageEnabledConfiguration createCoverageEnabledConfiguration(@Nullable RunConfigurationBase conf) {
        DartCoverageEnabledConfiguration dartCoverageEnabledConfiguration = new DartCoverageEnabledConfiguration(conf);
        if (dartCoverageEnabledConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageEnabledConfiguration"));
        }
        return dartCoverageEnabledConfiguration;
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @Nullable String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, Project project) {
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        return null;
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, @NotNull CoverageEnabledConfiguration config) {
        if (covRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "covRunner", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (coverageDataFileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageDataFileProvider", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createCoverageSuite"));
        }
        if (config instanceof DartCoverageEnabledConfiguration) {
            DartCoverageEnabledConfiguration dartConfig = (DartCoverageEnabledConfiguration)config;
            Project project = config.getConfiguration().getProject();
            String contextFilePath = ((DartCommandLineRunConfiguration)dartConfig.getConfiguration()).getRunnerParameters().getFilePath();
            return new DartCoverageSuite(project, name, coverageDataFileProvider, covRunner, contextFilePath, dartConfig.getCoverageProcess());
        }
        return null;
    }

    @Nullable
    public CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner coverageRunner) {
        if (coverageRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageRunner", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "createEmptyCoverageSuite"));
        }
        return new DartCoverageSuite();
    }

    @NotNull
    public CoverageAnnotator getCoverageAnnotator(Project project) {
        DartCoverageAnnotator dartCoverageAnnotator = DartCoverageAnnotator.getInstance(project);
        if (dartCoverageAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getCoverageAnnotator"));
        }
        return dartCoverageAnnotator;
    }

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "coverageEditorHighlightingApplicableTo"));
        }
        return psiFile instanceof DartFile;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "acceptedByFilters"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "acceptedByFilters"));
        }
        return psiFile instanceof DartFile;
    }

    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "recompileProjectAndRerunAction"));
        }
        if (chooseSuiteAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooseSuiteAction", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "recompileProjectAndRerunAction"));
        }
        return false;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQualifiedNames"));
        }
        HashSet<String> qualifiedNames = new HashSet<String>();
        qualifiedNames.add(DartCoverageEngine.getQName(sourceFile));
        HashSet<String> hashSet = qualifiedNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQualifiedNames"));
        }
        return hashSet;
    }

    @NotNull
    public String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQualifiedName"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQualifiedName"));
        }
        String string = DartCoverageEngine.getQName(sourceFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private static String getQName(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQName"));
        }
        String string = sourceFile.getVirtualFile().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getQName"));
        }
        return string;
    }

    @Nullable
    public List<PsiElement> findTestsByNames(@NotNull String[] testNames, @NotNull Project project) {
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "findTestsByNames"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "findTestsByNames"));
        }
        return null;
    }

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return !fileOrDir.isDirectory() && fileOrDir.getFileType() instanceof DartFileType;
    }

    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getTestMethodName"));
        }
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/jetbrains/lang/dart/coverage/DartCoverageEngine", "getTestMethodName"));
        }
        return null;
    }

    public String getPresentableText() {
        return "Dart Coverage";
    }
}

