/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.coverage.DartCoverageEnabledConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunConfiguration;
import com.jetbrains.lang.dart.ide.runner.server.DartCommandLineRunningState;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageProgramRunner
extends GenericProgramRunner {
    private static final Logger LOG = Logger.getInstance((String)DartCoverageProgramRunner.class.getName());
    private static final String ID = "DartCoverageProgramRunner";
    private boolean myCoveragePackageActivated;

    @NotNull
    public String getRunnerId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "getRunnerId"));
        }
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "canRun"));
        }
        return executorId.equals("Coverage") && profile instanceof DartCommandLineRunConfiguration;
    }

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        DartCommandLineRunConfiguration runConfiguration = (DartCommandLineRunConfiguration)env.getRunProfile();
        DartSdk sdk = DartSdk.getDartSdk(runConfiguration.getProject());
        if (sdk == null) {
            throw new ExecutionException(DartBundle.message("dart.sdk.is.not.configured", new Object[0]));
        }
        String dartPubPath = DartSdkUtil.getPubPath(sdk);
        RunContentDescriptor result = DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)env, (ProgramRunner)this);
        if (result == null) {
            return null;
        }
        if (!this.myCoveragePackageActivated && !this.activateCoverage(runConfiguration.getProject(), dartPubPath)) {
            throw new ExecutionException("Cannot activate pub package 'coverage'.");
        }
        ProcessHandler dartAppProcessHandler = result.getProcessHandler();
        if (dartAppProcessHandler != null) {
            ((DartCommandLineRunningState)state).addObservatoryUrlConsumer((Consumer<String>)((Consumer)observatoryUrl -> {
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "lambda$doExecute$0"));
                }
                DartCoverageProgramRunner.startCollectingCoverage(env, dartAppProcessHandler, observatoryUrl);
            }));
        }
        return result;
    }

    private static void startCollectingCoverage(@NotNull ExecutionEnvironment env, @NotNull ProcessHandler dartAppProcessHandler, @NotNull String observatoryUrl) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "startCollectingCoverage"));
        }
        if (dartAppProcessHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartAppProcessHandler", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "startCollectingCoverage"));
        }
        if (observatoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observatoryUrl", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "startCollectingCoverage"));
        }
        DartCommandLineRunConfiguration dartRC = (DartCommandLineRunConfiguration)env.getRunProfile();
        DartCoverageEnabledConfiguration coverageConfiguration = (DartCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)dartRC);
        String coverageFilePath = coverageConfiguration.getCoverageFilePath();
        DartSdk sdk = DartSdk.getDartSdk(env.getProject());
        LOG.assertTrue(sdk != null);
        GeneralCommandLine cmdline = new GeneralCommandLine().withExePath(DartSdkUtil.getPubPath(sdk)).withParameters(new String[]{"global", "run", "coverage:collect_coverage", "--uri", observatoryUrl, "--out", coverageFilePath, "--resume-isolates", "--wait-paused"});
        try {
            OSProcessHandler coverageProcess = new OSProcessHandler(cmdline);
            coverageProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner$1", "onTextAvailable"));
                    }
                    if (outputType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner$1", "onTextAvailable"));
                    }
                    LOG.debug(event.getText());
                }
            });
            coverageProcess.startNotify();
            coverageConfiguration.setCoverageProcess((ProcessHandler)coverageProcess);
            CoverageHelper.attachToProcess((RunConfigurationBase)dartRC, (ProcessHandler)dartAppProcessHandler, (RunnerSettings)env.getRunnerSettings());
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean activateCoverage(@NotNull Project project, @NotNull String dartPubPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "activateCoverage"));
        }
        if (dartPubPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartPubPath", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "activateCoverage"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (dartPubPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartPubPath", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "lambda$activateCoverage$1"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                this.checkIfCoverageActivated(dartPubPath);
                ProcessOutput activateOutput = new CapturingProcessHandler(new GeneralCommandLine().withExePath(dartPubPath).withParameters(new String[]{"global", "activate", "coverage"}).withRedirectErrorStream(true)).runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
                if (activateOutput.getExitCode() != 0) {
                    LOG.warn("'pub global activate coverage' exit code: " + activateOutput.getExitCode() + ", stdout:\n" + activateOutput.getStdout());
                }
                if (!this.myCoveragePackageActivated) {
                    this.checkIfCoverageActivated(dartPubPath);
                }
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }, "Activating Coverage Package...", true, project);
        return this.myCoveragePackageActivated;
    }

    private void checkIfCoverageActivated(@NotNull String dartPubPath) throws ExecutionException {
        if (dartPubPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartPubPath", "com/jetbrains/lang/dart/coverage/DartCoverageProgramRunner", "checkIfCoverageActivated"));
        }
        ProcessOutput listOutput = new CapturingProcessHandler(new GeneralCommandLine().withExePath(dartPubPath).withParameters(new String[]{"global", "list"}).withRedirectErrorStream(true)).runProcessWithProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        String listOutputStdout = listOutput.getStdout();
        if (listOutput.getExitCode() == 0) {
            if (listOutputStdout.startsWith("coverage ") || listOutputStdout.contains("\ncoverage ")) {
                this.myCoveragePackageActivated = true;
            }
        } else {
            LOG.warn("'pub global list' exit code: " + listOutput.getExitCode() + ", stdout:\n" + listOutputStdout);
        }
    }
}

