/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.coverage.DartCoverageData;
import com.jetbrains.lang.dart.coverage.DartCoverageEngine;
import com.jetbrains.lang.dart.coverage.DartCoverageSuite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageRunner
extends CoverageRunner {
    private static final String ID = "DartCoverageRunner";
    private static final Logger LOG = Logger.getInstance((String)DartCoverageRunner.class.getName());

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionDataFile", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "loadCoverageData"));
        }
        if (!(baseCoverageSuite instanceof DartCoverageSuite)) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref projectDataRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (sessionDataFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionDataFile", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "lambda$loadCoverageData$0"));
                }
                projectDataRef.set((Object)DartCoverageRunner.doLoadCoverageData(sessionDataFile, (DartCoverageSuite)baseCoverageSuite));
            }, "Loading Coverage Data...", true, baseCoverageSuite.getProject());
            return (ProjectData)projectDataRef.get();
        }
        return DartCoverageRunner.doLoadCoverageData(sessionDataFile, (DartCoverageSuite)baseCoverageSuite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ProjectData doLoadCoverageData(@NotNull File sessionDataFile, @NotNull DartCoverageSuite coverageSuite) {
        if (sessionDataFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionDataFile", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "doLoadCoverageData"));
        }
        if (coverageSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageSuite", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "doLoadCoverageData"));
        }
        ProcessHandler coverageProcess = coverageSuite.getCoverageProcess();
        if (coverageProcess != null) {
            for (int i = 0; i < 100; ++i) {
                ProgressManager.checkCanceled();
                if (coverageProcess.waitFor(100L)) break;
            }
            if (!coverageProcess.isProcessTerminated()) {
                coverageProcess.destroyProcess();
                return null;
            }
        }
        Project project = coverageSuite.getProject();
        String contextFilePath = coverageSuite.getContextFilePath();
        if (project == null || contextFilePath == null) {
            return null;
        }
        String contextId = DartAnalysisServerService.getInstance(project).execution_createContext(contextFilePath);
        if (contextId == null) {
            return null;
        }
        ProjectData projectData = new ProjectData();
        try {
            DartCoverageData data = (DartCoverageData)new Gson().fromJson((Reader)new BufferedReader(new FileReader(sessionDataFile)), DartCoverageData.class);
            if (data == null) {
                LOG.warn("Coverage file does not contain valid data.");
                ProjectData projectData2 = null;
                return projectData2;
            }
            for (Map.Entry<String, SortedMap<Integer, Integer>> entry : data.getMergedDartFileCoverageData().entrySet()) {
                ProgressManager.checkCanceled();
                String filePath = DartCoverageRunner.getFileForUri(project, contextId, entry.getKey());
                if (filePath == null) continue;
                SortedMap<Integer, Integer> lineHits = entry.getValue();
                ClassData classData = projectData.getOrCreateClassData(filePath);
                if (lineHits.size() == 0) {
                    classData.setLines(new LineData[1]);
                    continue;
                }
                LineData[] lines = new LineData[lineHits.lastKey() + 1];
                for (Map.Entry<Integer, Integer> hit : lineHits.entrySet()) {
                    LineData lineData = new LineData(hit.getKey().intValue(), null);
                    lineData.setHits(hit.getValue().intValue());
                    lines[hit.getKey().intValue()] = lineData;
                }
                classData.setLines(lines);
            }
        }
        catch (JsonSyntaxException | FileNotFoundException e) {
            LOG.warn(e);
        }
        finally {
            DartAnalysisServerService.getInstance(project).execution_deleteContext(contextId);
        }
        return projectData;
    }

    @Nullable
    private static String getFileForUri(@NotNull Project project, @NotNull String contextId, @NotNull String uri) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getFileForUri"));
        }
        if (contextId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextId", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getFileForUri"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getFileForUri"));
        }
        if (uri.startsWith("dart:_") || uri.startsWith("dart:") && uri.contains("-patch/")) {
            return null;
        }
        return DartAnalysisServerService.getInstance(project).execution_mapUri(contextId, null, uri);
    }

    @NotNull
    public String getPresentableName() {
        if ("Dart" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getPresentableName"));
        }
        return "Dart";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getId"));
        }
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        if ("json" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "getDataFileExtension"));
        }
        return "json";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/jetbrains/lang/dart/coverage/DartCoverageRunner", "acceptsCoverageEngine"));
        }
        return engine instanceof DartCoverageEngine;
    }
}

