/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.lang.dart.coverage.DartCoverageEngine;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartCoverageSuite
extends BaseCoverageSuite {
    @NonNls
    private static final String CONTEXT_FILE_PATH = "CONTEXT_FILE_PATH";
    @Nullable
    private String myContextFilePath;
    @Nullable
    private final ProcessHandler myCoverageProcess;

    public DartCoverageSuite() {
        this.myCoverageProcess = null;
    }

    public DartCoverageSuite(@NotNull Project project, @NotNull String name, @NotNull CoverageFileProvider fileProvider, @NotNull CoverageRunner coverageRunner, @Nullable String contextFilePath, @Nullable ProcessHandler coverageProcess) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/coverage/DartCoverageSuite", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/coverage/DartCoverageSuite", "<init>"));
        }
        if (fileProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProvider", "com/jetbrains/lang/dart/coverage/DartCoverageSuite", "<init>"));
        }
        if (coverageRunner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageRunner", "com/jetbrains/lang/dart/coverage/DartCoverageSuite", "<init>"));
        }
        super(name, fileProvider, System.currentTimeMillis(), false, false, false, coverageRunner, project);
        this.myContextFilePath = contextFilePath;
        this.myCoverageProcess = coverageProcess;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        DartCoverageEngine dartCoverageEngine = DartCoverageEngine.getInstance();
        if (dartCoverageEngine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/coverage/DartCoverageSuite", "getCoverageEngine"));
        }
        return dartCoverageEngine;
    }

    @Nullable
    public String getContextFilePath() {
        return this.myContextFilePath;
    }

    @Nullable
    public ProcessHandler getCoverageProcess() {
        return this.myCoverageProcess;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myContextFilePath != null) {
            element.setAttribute(CONTEXT_FILE_PATH, this.myContextFilePath);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String contextFilePath = element.getAttributeValue(CONTEXT_FILE_PATH);
        if (contextFilePath != null) {
            this.myContextFilePath = contextFilePath;
        }
    }
}

