/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.fixes;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.fixes.DartQuickFix;
import com.jetbrains.lang.dart.ide.annotator.DartProblemGroup;
import java.util.ArrayList;
import java.util.List;
import org.dartlang.analysis.server.protocol.AnalysisErrorFixes;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartQuickFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final VirtualFile myFile;
    private final int myOffset;
    @Nullable
    private final String myErrorCode;
    @NotNull
    private final String myErrorSeverity;
    @NotNull
    private final List<DartQuickFix> myQuickFixes;
    private volatile long myPsiModCountWhenRequestSent;

    public DartQuickFixSet(@NotNull PsiManager psiManager, @NotNull VirtualFile file, int offset, @Nullable String errorCode, @NotNull String errorSeverity) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/jetbrains/lang/dart/fixes/DartQuickFixSet", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/fixes/DartQuickFixSet", "<init>"));
        }
        if (errorSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSeverity", "com/jetbrains/lang/dart/fixes/DartQuickFixSet", "<init>"));
        }
        this.myQuickFixes = new ArrayList<DartQuickFix>(5);
        this.myPsiManager = psiManager;
        this.myFile = file;
        this.myOffset = offset;
        this.myErrorCode = errorCode;
        this.myErrorSeverity = errorSeverity;
        for (int i = 0; i < 5; ++i) {
            this.myQuickFixes.add(new DartQuickFix(this, i));
        }
    }

    @NotNull
    public List<DartQuickFix> getQuickFixes() {
        List<DartQuickFix> list = this.myQuickFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/fixes/DartQuickFixSet", "getQuickFixes"));
        }
        return list;
    }

    synchronized void ensureInitialized() {
        long modCount = this.myPsiManager.getModificationTracker().getModificationCount();
        if (this.myPsiModCountWhenRequestSent == modCount) {
            return;
        }
        this.myPsiModCountWhenRequestSent = modCount;
        for (DartQuickFix fix : this.myQuickFixes) {
            fix.setSourceChange(null);
        }
        Consumer consumer = fixes -> {
            long modCountWhenReceivedFixes = this.myPsiManager.getModificationTracker().getModificationCount();
            if (this.myPsiModCountWhenRequestSent != modCountWhenReceivedFixes) {
                return;
            }
            if (fixes == null || fixes.isEmpty()) {
                if (this.myErrorCode != null) {
                    this.myQuickFixes.get(0).setSuppressActionDelegate(new DartProblemGroup.DartSuppressAction(this.myErrorCode, this.myErrorSeverity, false));
                    this.myQuickFixes.get(1).setSuppressActionDelegate(new DartProblemGroup.DartSuppressAction(this.myErrorCode, this.myErrorSeverity, true));
                }
            } else {
                int index = 0;
                for (AnalysisErrorFixes fix : fixes) {
                    for (SourceChange sourceChange : fix.getFixes()) {
                        this.myQuickFixes.get(index).setSourceChange(sourceChange);
                        if (++index != 5) continue;
                        return;
                    }
                }
            }
        };
        DartAnalysisServerService.getInstance(this.myPsiManager.getProject()).askForFixesAndWaitABitIfReceivedQuickly(this.myFile, this.myOffset, (Consumer<List<AnalysisErrorFixes>>)consumer);
    }
}

