/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.flutter;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterUtil {
    private static final String FLUTTER_MODULE_TYPE_ID = "FLUTTER_MODULE_TYPE";
    private static final boolean FLUTTER_PLUGIN_INSTALLED = PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)"io.flutter"));

    @Nullable
    public static String getFlutterRoot(@NotNull String dartSdkPath) {
        if (dartSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartSdkPath", "com/jetbrains/lang/dart/flutter/FlutterUtil", "getFlutterRoot"));
        }
        String suffix = "/bin/cache/dart-sdk";
        return dartSdkPath.endsWith("/bin/cache/dart-sdk") ? dartSdkPath.substring(0, dartSdkPath.length() - "/bin/cache/dart-sdk".length()) : null;
    }

    public static boolean isFlutterModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/flutter/FlutterUtil", "isFlutterModule"));
        }
        return FLUTTER_MODULE_TYPE_ID.equals(ModuleType.get((Module)module).getId());
    }

    public static boolean isFlutterPluginInstalled() {
        return FLUTTER_PLUGIN_INSTALLED;
    }
}

