/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.highlight;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiErrorElement;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;

public class DartHighlightingErrorFilter
extends HighlightErrorFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/highlight/DartHighlightingErrorFilter", "shouldHighlightErrorElement"));
        }
        if (element.getLanguage() != DartLanguage.INSTANCE) {
            return true;
        }
        VirtualFile file = DartResolveUtil.getRealVirtualFile(element.getContainingFile());
        return file == null || !file.isInLocalFileSystem() || !ProjectFileIndex.getInstance((Project)element.getProject()).isInContent(file);
    }
}

