/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.index.DartClassIndex;
import com.jetbrains.lang.dart.psi.DartComponentName;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartClassContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        Collection<String> result = DartClassIndex.getNames(project);
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartClassContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        List<DartComponentName> result = DartClassIndex.getItemsByName(name, project, scope);
        if (result.size() == 0) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartClassContributor", "getItemsByName"));
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        NavigationItem[] navigationItemArray = result.toArray(new NavigationItem[result.size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartClassContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

