/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;

final class DartFileUrlMapper
extends FileUrlMapper {
    private static final String SDK_URL_MARKER = "/packages/$sdk/lib/";
    private static final String PACKAGE_URL_MARKER = "/packages/";

    DartFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
        }
        if (currentAuthority == null || file.getFileType() != DartFileType.INSTANCE) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
            }
            return list;
        }
        String dartUri = DartUrlResolver.getInstance(project, file).getDartUrlForFile(file);
        if (!dartUri.startsWith("package:")) {
            List<Url> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
            }
            return list;
        }
        if (BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)currentAuthority)) {
            VirtualFile pubspec = PubspecYamlUtil.findPubspecYamlFile(project, file);
            if (pubspec == null) {
                List<Url> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
                }
                return list;
            }
            VirtualFile dartRoot = pubspec.getParent();
            String dartRootUrlPath = WebServerPathToFileManager.getInstance((Project)project).getPath(dartRoot);
            if (dartRootUrlPath == null) {
                List<Url> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
                }
                return list;
            }
            Url dartRootUrl = Urls.newHttpUrl((String)currentAuthority, (String)("/" + project.getName() + "/" + dartRootUrlPath));
            String urlPath = StringUtil.trimEnd((String)dartRootUrl.getPath(), (String)"/") + "/web/packages/" + dartUri.substring("package:".length());
            List<Url> list = Collections.singletonList(Urls.newHttpUrl((String)currentAuthority, (String)urlPath));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
            }
            return list;
        }
        String urlPath = PACKAGE_URL_MARKER + dartUri.substring("package:".length());
        List<Url> list = Collections.singletonList(Urls.newHttpUrl((String)currentAuthority, (String)urlPath));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getUrls"));
        }
        return list;
    }

    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getFile"));
        }
        String scheme = url.getScheme();
        String path = url.getPath();
        if ("dart".equals(scheme)) {
            return DartUrlResolver.findFileInDartSdkLibFolder(project, DartSdk.getDartSdk(project), "dart:" + path);
        }
        if ("package".equals(scheme)) {
            String packageUri = "package:" + path;
            VirtualFile contextFile = DartFileUrlMapper.findContextFile(project, requestor);
            if (contextFile != null) {
                return (VirtualFile)ReadAction.compute(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "lambda$getFile$0"));
                    }
                    return DartUrlResolver.getInstance(project, contextFile).findFileByDartUrl(packageUri);
                });
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return DumbService.getInstance((Project)project).isDumb() ? null : DartFileUrlMapper.findFileInAnyPackagesFolder(project, packageUri);
            }
            return (VirtualFile)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "lambda$getFile$1"));
                }
                return DartFileUrlMapper.findFileInAnyPackagesFolder(project, packageUri);
            });
        }
        if ("http".equalsIgnoreCase(scheme)) {
            VirtualFile contextFile;
            int sdkUrlMarkerIndex = path.indexOf(SDK_URL_MARKER);
            if (sdkUrlMarkerIndex >= 0) {
                String relPath = path.substring(sdkUrlMarkerIndex + SDK_URL_MARKER.length());
                return DartUrlResolver.findFileInDartSdkLibFolder(project, DartSdk.getDartSdk(project), "dart:" + relPath);
            }
            int packageUrlMarkerIndex = path.lastIndexOf(PACKAGE_URL_MARKER);
            if (packageUrlMarkerIndex >= 0 && (contextFile = DartFileUrlMapper.findContextFile(project, requestor)) != null) {
                String packageUri = "package:" + path.substring(packageUrlMarkerIndex + PACKAGE_URL_MARKER.length());
                return (VirtualFile)ReadAction.compute(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "lambda$getFile$2"));
                    }
                    return DartUrlResolver.getInstance(project, contextFile).findFileByDartUrl(packageUri);
                });
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContextFile(@NotNull Project project, @Nullable Url url) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "findContextFile"));
        }
        if (url == null) {
            return null;
        }
        for (FileUrlMapper urlMapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            VirtualFile file;
            if (urlMapper instanceof DartFileUrlMapper || (file = urlMapper.getFile(url, project, url)) == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFileInAnyPackagesFolder(@NotNull Project project, @NotNull String packageUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "findFileInAnyPackagesFolder"));
        }
        if (packageUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageUrl", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "findFileInAnyPackagesFolder"));
        }
        for (VirtualFile yamlFile : FilenameIndex.getVirtualFilesByName((Project)project, (String)"pubspec.yaml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            VirtualFile file = DartUrlResolver.getInstance(project, yamlFile).findFileByDartUrl(packageUrl);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public FileType getFileType(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/DartFileUrlMapper", "getFileType"));
        }
        return "dart".equals(url.getScheme()) || "package".equals(url.getScheme()) ? DartFileType.INSTANCE : null;
    }
}

