/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.lang.dart.ide.index.DartSymbolIndex;
import com.jetbrains.lang.dart.psi.DartComponentName;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartSymbolContributor
implements ChooseByNameContributor {
    @NotNull
    public String[] getNames(@NotNull Project project, boolean includeNonProjectItems) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getNames"));
        }
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        String[] stringArray = DartSymbolIndex.getAllSymbols(scope);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(@NotNull String name, @NotNull String pattern, @NotNull Project project, boolean includeNonProjectItems) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getItemsByName"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getItemsByName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getItemsByName"));
        }
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        List<DartComponentName> result = DartSymbolIndex.getItemsByName(name, project, scope);
        NavigationItem[] navigationItemArray = result.toArray(new NavigationItem[result.size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/DartSymbolContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

