/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide;

import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class DartWritingAccessProvider
implements NonProjectFileWritingAccessExtension {
    private final Project myProject;

    public DartWritingAccessProvider(Project project) {
        this.myProject = project;
    }

    public boolean isNotWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/DartWritingAccessProvider", "isNotWritable"));
        }
        return DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(this.myProject, file);
    }

    public static boolean isInDartSdkOrDartPackagesFolder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/DartWritingAccessProvider", "isInDartSdkOrDartPackagesFolder"));
        }
        VirtualFile vFile = psiFile.getOriginalFile().getVirtualFile();
        return vFile != null && DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(psiFile.getProject(), vFile);
    }

    public static boolean isInDartSdkOrDartPackagesFolder(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/DartWritingAccessProvider", "isInDartSdkOrDartPackagesFolder"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/DartWritingAccessProvider", "isInDartSdkOrDartPackagesFolder"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInLibraryClasses(file) && !fileIndex.isInContent(file)) {
            return true;
        }
        return fileIndex.isExcluded(file) || fileIndex.isInContent(file) && DartWritingAccessProvider.isInDartPackagesFolder(fileIndex, file);
    }

    private static boolean isInDartPackagesFolder(ProjectFileIndex fileIndex, VirtualFile file) {
        VirtualFile parent = file;
        while ((parent = parent.getParent()) != null && fileIndex.isInContent(parent)) {
            if (!"packages".equals(parent.getName())) continue;
            return VfsUtilCore.findRelativeFile((String)"../pubspec.yaml", (VirtualFile)parent) != null;
        }
        return false;
    }
}

