/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.LightweightHint;
import com.intellij.util.SmartList;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDartFileProcessingAction
extends AnAction
implements DumbAware {
    public AbstractDartFileProcessingAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (!AbstractDartFileProcessingAction.isApplicableFile(psiFile)) {
                return;
            }
            this.runOverEditor(project, editor, psiFile);
        } else {
            VirtualFile[] filesAndDirs = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(event.getDataContext());
            if (filesAndDirs != null && DartAnalysisServerService.getInstance(project).serverReadyForRequest(project)) {
                List<VirtualFile> files = AbstractDartFileProcessingAction.getApplicableVirtualFiles(project, filesAndDirs);
                this.runOverFiles(project, files);
            }
        }
    }

    @NotNull
    protected abstract String getActionTextForEditor();

    @NotNull
    protected abstract String getActionTextForFiles();

    protected abstract void runOverEditor(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    protected abstract void runOverFiles(@NotNull Project var1, @NotNull List<VirtualFile> var2);

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            presentation.setVisible(psiFile != null && psiFile.getFileType() == DartFileType.INSTANCE);
            presentation.setEnabled(AbstractDartFileProcessingAction.isApplicableFile(psiFile));
            presentation.setText(this.getActionTextForEditor());
            return;
        }
        VirtualFile[] filesAndDirs = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(event.getDataContext());
        if (filesAndDirs == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(AbstractDartFileProcessingAction.mayHaveApplicableDartFiles(project, filesAndDirs));
        presentation.setText(this.getActionTextForFiles());
    }

    public static void showHintLater(@NotNull Editor editor, @NotNull String text, boolean error) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "showHintLater"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "showHintLater"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "lambda$showHintLater$0"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "lambda$showHintLater$0"));
            }
            JComponent component = error ? HintUtil.createErrorLabel((String)text) : HintUtil.createInformationLabel((String)text);
            LightweightHint hint = new LightweightHint(component);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
        }, ModalityState.NON_MODAL, o -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "lambda$showHintLater$1"));
            }
            return editor.isDisposed() || !editor.getComponent().isShowing();
        });
    }

    @NotNull
    private static List<VirtualFile> getApplicableVirtualFiles(@NotNull Project project, @NotNull VirtualFile[] filesAndDirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "getApplicableVirtualFiles"));
        }
        if (filesAndDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesAndDirs", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "getApplicableVirtualFiles"));
        }
        SmartList result = new SmartList();
        GlobalSearchScope dirScope = null;
        for (VirtualFile fileOrDir : filesAndDirs) {
            if (fileOrDir.isDirectory()) {
                if (dirScope == null) {
                    dirScope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)fileOrDir, (boolean)true);
                    continue;
                }
                dirScope = dirScope.union((SearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)fileOrDir, (boolean)true));
                continue;
            }
            if (!AbstractDartFileProcessingAction.isApplicableFile(project, fileOrDir)) continue;
            result.add(fileOrDir);
        }
        if (dirScope != null) {
            for (VirtualFile file : FileTypeIndex.getFiles((FileType)DartFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project).intersectWith(dirScope))) {
                if (!AbstractDartFileProcessingAction.isApplicableFile(project, file)) continue;
                result.add(file);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "getApplicableVirtualFiles"));
        }
        return smartList;
    }

    private static boolean isApplicableFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "isApplicableFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "isApplicableFile"));
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return false;
        }
        if (!DartSdkLibUtil.isDartSdkEnabled(module)) {
            return false;
        }
        return !DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(project, file);
    }

    private static boolean isApplicableFile(@Nullable PsiFile psiFile) {
        if (psiFile == null || psiFile.getVirtualFile() == null || psiFile.getFileType() != DartFileType.INSTANCE) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return false;
        }
        if (!DartSdkLibUtil.isDartSdkEnabled(module)) {
            return false;
        }
        return !DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder(psiFile);
    }

    private static boolean mayHaveApplicableDartFiles(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "mayHaveApplicableDartFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/lang/dart/ide/actions/AbstractDartFileProcessingAction", "mayHaveApplicableDartFiles"));
        }
        for (VirtualFile fileOrDir : files) {
            if (!fileOrDir.isDirectory() && AbstractDartFileProcessingAction.isApplicableFile(project, fileOrDir)) {
                return true;
            }
            if (!fileOrDir.isDirectory() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(fileOrDir) || !FileTypeIndex.containsFileOfType((FileType)DartFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)fileOrDir, (boolean)true))) continue;
            return true;
        }
        return false;
    }
}

