/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.sdk.DartConfigurable;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.sdk.DartSdkUtil;
import icons.DartIcons;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartEditorNotificationsProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"DartEditorNotificationsProvider");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Dart Support");
    @NotNull
    private final Project myProject;

    public DartEditorNotificationsProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile vFile, @NotNull FileEditor fileEditor) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (!vFile.isInLocalFileSystem()) {
            return null;
        }
        if ("pubspec.yaml".equalsIgnoreCase(vFile.getName())) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)this.myProject);
            if (module == null) {
                return null;
            }
            if (FlutterUtil.isFlutterPluginInstalled() && FlutterUtil.isFlutterModule(module)) {
                return null;
            }
            DartSdk sdk = DartSdk.getDartSdk(this.myProject);
            if (sdk != null && DartSdkLibUtil.isDartSdkEnabled(module)) {
                return new PubActionsPanel();
            }
        }
        if ("pubspec.yaml".equalsIgnoreCase(vFile.getName()) || vFile.getFileType() == DartFileType.INSTANCE) {
            DartSdk sdk = DartSdk.getDartSdk(this.myProject);
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            if (psiFile == null) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            if (sdk == null) {
                String sdkPath = DartSdkUtil.getFirstKnownDartSdkPath();
                if (DartSdkUtil.isDartSdkHome(sdkPath)) {
                    return this.createNotificationToEnableDartSupport(module);
                }
                String message = DartBundle.message("dart.sdk.is.not.configured", new Object[0]);
                String downloadUrl = "https://www.dartlang.org/redirects/sdk-download-stable";
                EditorNotificationPanel panel = new EditorNotificationPanel().icon(DartIcons.Dart_16).text(message);
                panel.createActionLabel(DartBundle.message("download.dart.sdk", new Object[0]), (Runnable)new OpenWebPageRunnable("https://www.dartlang.org/redirects/sdk-download-stable"));
                panel.createActionLabel(DartBundle.message("open.dart.settings", new Object[0]), (Runnable)new OpenDartSettingsRunnable(this.myProject));
                return panel;
            }
            if (!DartSdkLibUtil.isDartSdkEnabled(module)) {
                return this.createNotificationToEnableDartSupport(module);
            }
            if (!DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
                String message = DartBundle.message("old.dart.sdk.configured", "1.12", sdk.getVersion());
                String downloadUrl = "https://www.dartlang.org/redirects/sdk-download-stable";
                EditorNotificationPanel panel = new EditorNotificationPanel().icon(DartIcons.Dart_16).text(message);
                panel.createActionLabel(DartBundle.message("download.dart.sdk", new Object[0]), (Runnable)new OpenWebPageRunnable("https://www.dartlang.org/redirects/sdk-download-stable"));
                panel.createActionLabel(DartBundle.message("open.dart.settings", new Object[0]), (Runnable)new OpenDartSettingsRunnable(this.myProject));
                return panel;
            }
        }
        return null;
    }

    @NotNull
    private EditorNotificationPanel createNotificationToEnableDartSupport(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "createNotificationToEnableDartSupport"));
        }
        String message = DartSdkLibUtil.isIdeWithMultipleModuleSupport() ? DartBundle.message("dart.support.is.not.enabled.for.module.0", module.getName()) : DartBundle.message("dart.support.is.not.enabled.for.project", new Object[0]);
        EditorNotificationPanel panel = new EditorNotificationPanel().icon(DartIcons.Dart_16).text(message);
        panel.createActionLabel(DartBundle.message("enable.dart.support", new Object[0]), (Runnable)new EnableDartSupportForModule(module));
        panel.createActionLabel(DartBundle.message("open.dart.settings", new Object[0]), (Runnable)new OpenDartSettingsRunnable(this.myProject));
        EditorNotificationPanel editorNotificationPanel = panel;
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider", "createNotificationToEnableDartSupport"));
        }
        return editorNotificationPanel;
    }

    private static class OpenDartSettingsRunnable
    implements Runnable {
        @NotNull
        private final Project myProject;

        private OpenDartSettingsRunnable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider$OpenDartSettingsRunnable", "<init>"));
            }
            this.myProject = project;
        }

        @Override
        public void run() {
            DartConfigurable.openDartSettings(this.myProject);
        }
    }

    private static class OpenWebPageRunnable
    implements Runnable {
        @NotNull
        private final String myUrl;

        private OpenWebPageRunnable(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider$OpenWebPageRunnable", "<init>"));
            }
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse((String)this.myUrl);
        }
    }

    private static class EnableDartSupportForModule
    implements Runnable {
        private final Module myModule;

        public EnableDartSupportForModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider$EnableDartSupportForModule", "<init>"));
            }
            this.myModule = module;
        }

        @Override
        public void run() {
            final Project project = this.myModule.getProject();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (DartSdk.getDartSdk(project) == null) {
                    String sdkPath = DartSdkUtil.getFirstKnownDartSdkPath();
                    if (DartSdkUtil.isDartSdkHome(sdkPath)) {
                        DartSdkLibUtil.ensureDartSdkConfigured(project, sdkPath);
                    } else {
                        return;
                    }
                }
                DartSdkLibUtil.enableDartSdk(this.myModule);
            });
            DartSdk sdk = DartSdk.getDartSdk(project);
            if (sdk != null && DartSdkLibUtil.isDartSdkEnabled(this.myModule)) {
                String title = DartSdkLibUtil.isIdeWithMultipleModuleSupport() ? DartBundle.message("dart.support.enabled.for.module.0", this.myModule.getName()) : DartBundle.message("dart.support.enabled", new Object[0]);
                String message = DartBundle.message("dart.sdk.0.open.dart.settings", sdk.getVersion());
                NotificationListener.Adapter listener = new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider$EnableDartSupportForModule$1", "hyperlinkActivated"));
                        }
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/lang/dart/ide/actions/DartEditorNotificationsProvider$EnableDartSupportForModule$1", "hyperlinkActivated"));
                        }
                        DartConfigurable.openDartSettings(project);
                    }
                };
                NOTIFICATION_GROUP.createNotification(title, message, NotificationType.INFORMATION, (NotificationListener)listener).notify(project);
            }
        }
    }

    private static class PubActionsPanel
    extends EditorNotificationPanel {
        private PubActionsPanel() {
            super(EditorColors.GUTTER_BACKGROUND);
            this.myLinksPanel.add(new JLabel("Pub actions:"));
            this.createActionLabel(DartBundle.message("get.dependencies", new Object[0]), "Dart.pub.get");
            this.createActionLabel(DartBundle.message("upgrade.dependencies", new Object[0]), "Dart.pub.upgrade");
            this.createActionLabel("Build...", "Dart.pub.build");
            this.myLinksPanel.add(new JSeparator(1));
            this.createActionLabel("Repair cache...", "Dart.pub.cache.repair");
        }
    }
}

