/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class DartInheritorsSearcher
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters parameters, @NotNull Processor<PsiElement> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "processQuery"));
        }
        Ref fileRef = Ref.create();
        Ref offsetRef = Ref.create();
        Ref componentTypeRef = Ref.create();
        DartInheritorsSearcher.prepare(parameters, (Ref<VirtualFile>)fileRef, (Ref<Integer>)offsetRef, (Ref<DartComponentType>)componentTypeRef);
        if (fileRef.isNull() || offsetRef.isNull() || componentTypeRef.isNull()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$processQuery$1"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$processQuery$1"));
            }
            List hierarchyItems = (List)CachedValuesManager.getCachedValue((PsiElement)parameters.getElement(), () -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$null$0"));
                }
                DartAnalysisServerService das = DartAnalysisServerService.getInstance(parameters.getElement().getProject());
                List<TypeHierarchyItem> items = das.search_getTypeHierarchy((VirtualFile)fileRef.get(), (Integer)offsetRef.get(), false);
                return new CachedValueProvider.Result(items, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            List<DartComponent> components = componentTypeRef.get() == DartComponentType.CLASS ? DartInheritorsSearcher.getSubClasses(parameters.getElement().getProject(), parameters.getScope(), hierarchyItems) : DartInheritorsSearcher.getSubMembers(parameters.getElement().getProject(), parameters.getScope(), hierarchyItems);
            for (DartComponent component : components) {
                consumer.process((Object)component);
            }
        });
    }

    private static void prepare(@NotNull DefinitionsScopedSearch.SearchParameters parameters, @NotNull Ref<VirtualFile> fileRef, @NotNull Ref<Integer> offsetRef, @NotNull Ref<DartComponentType> componentTypeRef) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "prepare"));
        }
        if (fileRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "prepare"));
        }
        if (offsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "prepare"));
        }
        if (componentTypeRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTypeRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "prepare"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile file;
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$prepare$2"));
            }
            if (fileRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$prepare$2"));
            }
            if (offsetRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$prepare$2"));
            }
            if (componentTypeRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTypeRef", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "lambda$prepare$2"));
            }
            PsiElement element = parameters.getElement();
            if (element.getLanguage() != DartLanguage.INSTANCE) {
                return;
            }
            DartComponentType componentType = DartComponentType.typeOf(element);
            if (componentType != DartComponentType.CLASS && componentType != DartComponentType.METHOD && componentType != DartComponentType.OPERATOR) {
                return;
            }
            DartComponentName componentName = element instanceof DartComponentName ? (DartComponentName)element : (element instanceof DartComponent ? ((DartComponent)element).getComponentName() : null);
            VirtualFile virtualFile = file = componentName == null ? null : DartResolveUtil.getRealVirtualFile(componentName.getContainingFile());
            if (file != null) {
                fileRef.set((Object)file);
                offsetRef.set((Object)componentName.getTextRange().getStartOffset());
                componentTypeRef.set((Object)componentType);
            }
        });
    }

    @NotNull
    public static List<DartComponent> getSubClasses(@NotNull Project project, @NotNull SearchScope scope, @NotNull List<TypeHierarchyItem> hierarchyItems) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubClasses"));
        }
        if (hierarchyItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyItems", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubClasses"));
        }
        if (hierarchyItems.isEmpty()) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubClasses"));
            }
            return list;
        }
        ArrayList<DartComponent> result = new ArrayList<DartComponent>(hierarchyItems.size());
        DartInheritorsSearcher.addSubClasses(project, scope, Sets.newHashSet(), hierarchyItems, result, hierarchyItems.get(0), false);
        ArrayList<DartComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubClasses"));
        }
        return arrayList;
    }

    @NotNull
    public static List<DartComponent> getSubMembers(@NotNull Project project, @NotNull SearchScope scope, @NotNull List<TypeHierarchyItem> hierarchyItems) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubMembers"));
        }
        if (hierarchyItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyItems", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubMembers"));
        }
        if (hierarchyItems.isEmpty()) {
            List<DartComponent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubMembers"));
            }
            return list;
        }
        ArrayList<DartComponent> result = new ArrayList<DartComponent>(hierarchyItems.size());
        DartInheritorsSearcher.addSubMembers(project, scope, Sets.newHashSet(), hierarchyItems, result, hierarchyItems.get(0), false);
        ArrayList<DartComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "getSubMembers"));
        }
        return arrayList;
    }

    private static void addSubClasses(@NotNull Project project, @NotNull SearchScope scope, @NotNull Set<TypeHierarchyItem> visited, @NotNull List<TypeHierarchyItem> hierarchyItems, @NotNull List<DartComponent> components, @NotNull TypeHierarchyItem currentItem, boolean addItem) {
        Element element;
        Location location;
        DartComponent component;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (hierarchyItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyItems", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (currentItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentItem", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubClasses"));
        }
        if (!visited.add(currentItem)) {
            return;
        }
        if (addItem && (component = DartHierarchyUtil.findDartComponent(project, location = (element = currentItem.getClassElement()).getLocation())) != null && DartInheritorsSearcher.isInScope(scope, (PsiElement)component)) {
            components.add(component);
        }
        for (int subIndex : currentItem.getSubclasses()) {
            TypeHierarchyItem subItem = hierarchyItems.get(subIndex);
            DartInheritorsSearcher.addSubClasses(project, scope, visited, hierarchyItems, components, subItem, true);
        }
    }

    private static void addSubMembers(@NotNull Project project, @NotNull SearchScope scope, @NotNull Set<TypeHierarchyItem> visited, @NotNull List<TypeHierarchyItem> hierarchyItems, @NotNull List<DartComponent> components, @NotNull TypeHierarchyItem currentItem, boolean addItem) {
        Location location;
        DartComponent component;
        Element element;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (hierarchyItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyItems", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (currentItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentItem", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "addSubMembers"));
        }
        if (!visited.add(currentItem)) {
            return;
        }
        if (addItem && (element = currentItem.getMemberElement()) != null && (component = DartHierarchyUtil.findDartComponent(project, location = element.getLocation())) != null && DartInheritorsSearcher.isInScope(scope, (PsiElement)component)) {
            components.add(component);
        }
        for (int subIndex : currentItem.getSubclasses()) {
            TypeHierarchyItem subItem = hierarchyItems.get(subIndex);
            DartInheritorsSearcher.addSubMembers(project, scope, visited, hierarchyItems, components, subItem, true);
        }
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiElement element) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "isInScope"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/actions/DartInheritorsSearcher", "isInScope"));
        }
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file == null) {
            return false;
        }
        return scope.contains(file);
    }
}

