/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.lang.dart.DartBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPubBuildDialog
extends DialogWrapper {
    private static final String DART_PUB_BUILD_MODE_KEY = "DART_PUB_BUILD_MODE";
    private static final String DART_PUB_CUSTOM_BUILD_MODE_KEY = "DART_PUB_CUSTOM_BUILD_MODE";
    private static final String RELEASE_MODE = "release";
    private static final String DEBUG_MODE = "debug";
    private static final String OTHER_MODE = "other";
    private static final String DEFAULT_MODE = "release";
    private static final String DART_PUB_BUILD_OUTPUT_KEY = "DART_PUB_BUILD_OUTPUT_KEY";
    private static final String DEFAULT_OUTPUT_FOLDER = "build";
    private JPanel myMainPanel;
    private JBRadioButton myReleaseRadioButton;
    private JBRadioButton myDebugRadioButton;
    private JBRadioButton myOtherRadioButton;
    private JTextField myOtherModeTextField;
    private TextFieldWithBrowseButton myOutputFolderField;
    @NotNull
    private final Project myProject;

    public DartPubBuildDialog(@NotNull Project project, @NotNull VirtualFile packageDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "<init>"));
        }
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DartBundle.message("dart.pub.build.title", objectArray));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DartPubBuildDialog.this.updateControls();
            }
        };
        this.myReleaseRadioButton.addActionListener(listener);
        this.myDebugRadioButton.addActionListener(listener);
        this.myOtherRadioButton.addActionListener(listener);
        this.myOtherRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DartPubBuildDialog.this.myOtherRadioButton.isSelected()) {
                    IdeFocusManager.getInstance((Project)DartPubBuildDialog.this.myProject).requestFocus((Component)DartPubBuildDialog.this.myOtherModeTextField, true);
                }
            }
        });
        final String packagePathSlash = FileUtil.toSystemDependentName((String)(packageDir.getPath() + "/"));
        this.myOutputFolderField.addBrowseFolderListener("Output Folder", null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor(), (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                String path = component.getText();
                if (SystemInfo.isWindows && FileUtil.isWindowsAbsolutePath((String)path) || !SystemInfo.isWindows && FileUtil.isUnixAbsolutePath((String)path)) {
                    return path;
                }
                return packagePathSlash + path;
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog$3", "setText"));
                }
                if (text.startsWith(packagePathSlash) && !text.equals(packagePathSlash)) {
                    component.setText(text.substring(packagePathSlash.length()));
                } else {
                    component.setText(text);
                }
            }
        });
        this.reset();
        this.init();
    }

    private void reset() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String mode = propertiesComponent.getValue(DART_PUB_BUILD_MODE_KEY, "release");
        if (mode.equals("release")) {
            this.myReleaseRadioButton.setSelected(true);
        } else if (mode.equals(DEBUG_MODE)) {
            this.myDebugRadioButton.setSelected(true);
        } else {
            this.myOtherRadioButton.setSelected(true);
        }
        this.myOtherModeTextField.setText(propertiesComponent.getValue(DART_PUB_CUSTOM_BUILD_MODE_KEY, ""));
        this.myOutputFolderField.setText(propertiesComponent.getValue(DART_PUB_BUILD_OUTPUT_KEY, DEFAULT_OUTPUT_FOLDER));
        this.updateControls();
    }

    private void updateControls() {
        this.myOtherModeTextField.setEnabled(this.myOtherRadioButton.isSelected());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myOtherRadioButton.isSelected()) {
            return this.myOtherModeTextField;
        }
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myOtherRadioButton.isSelected() && StringUtil.isEmptyOrSpaces((String)this.myOtherModeTextField.getText())) {
            return new ValidationInfo(DartBundle.message("pub.build.mode.not.specified", new Object[0]));
        }
        return null;
    }

    protected void doOKAction() {
        this.saveDialogState();
        super.doOKAction();
    }

    private void saveDialogState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String mode = this.myReleaseRadioButton.isSelected() ? "release" : (this.myDebugRadioButton.isSelected() ? DEBUG_MODE : OTHER_MODE);
        propertiesComponent.setValue(DART_PUB_BUILD_MODE_KEY, mode, "release");
        if (this.myOtherRadioButton.isSelected()) {
            propertiesComponent.setValue(DART_PUB_CUSTOM_BUILD_MODE_KEY, this.myOtherModeTextField.getText().trim());
        }
        String outputPath = StringUtil.nullize((String)this.myOutputFolderField.getText().trim());
        propertiesComponent.setValue(DART_PUB_BUILD_OUTPUT_KEY, outputPath, DEFAULT_OUTPUT_FOLDER);
    }

    @NotNull
    public String getPubBuildMode() {
        if (this.myReleaseRadioButton.isSelected()) {
            if ("release" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "getPubBuildMode"));
            }
            return "release";
        }
        if (this.myDebugRadioButton.isSelected()) {
            if (DEBUG_MODE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "getPubBuildMode"));
            }
            return DEBUG_MODE;
        }
        String string = this.myOtherModeTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "getPubBuildMode"));
        }
        return string;
    }

    @NotNull
    public String getOutputFolder() {
        String path = this.myOutputFolderField.getText().trim();
        if (path.isEmpty()) {
            path = DEFAULT_OUTPUT_FOLDER;
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartPubBuildDialog", "getOutputFolder"));
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Build mode:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myReleaseRadioButton = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setSelected(true);
        jBRadioButton3.setText("Release");
        jBRadioButton3.setMnemonic('R');
        jBRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        this.myDebugRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Debug");
        jBRadioButton2.setMnemonic('D');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        this.myOtherRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Other:");
        jBRadioButton.setMnemonic('O');
        jBRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myOtherModeTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Output folder:");
        jBLabel2.setDisplayedMnemonic('U');
        jBLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, new Dimension(250, -1), null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10)));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

