/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class DartServerGotoSuperHandler
implements LanguageCodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartServerGotoSuperHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/DartServerGotoSuperHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/lang/dart/ide/actions/DartServerGotoSuperHandler", "invoke"));
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        DartComponent inComponent = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)at, DartComponent.class);
        DartComponent inClass = (DartComponent)PsiTreeUtil.getParentOfType((PsiElement)at, DartClass.class);
        if (inClass == null || inComponent == null || inComponent.getComponentName() == null) {
            return;
        }
        boolean isInClass = inComponent instanceof DartClass;
        VirtualFile virtualFile = file.getVirtualFile();
        int offset = inComponent.getComponentName().getTextRange().getStartOffset();
        List<TypeHierarchyItem> items = DartAnalysisServerService.getInstance(project).search_getTypeHierarchy(virtualFile, offset, true);
        ArrayList supers = Lists.newArrayList();
        if (!items.isEmpty()) {
            TypeHierarchyItem superItem;
            TypeHierarchyItem seed = items.get(0);
            Integer superIndex = seed.getSuperclass();
            if (superIndex != null) {
                TypeHierarchyItem superItem2 = items.get(superIndex);
                DartServerGotoSuperHandler.addSuperComponent(project, supers, isInClass, superItem2);
            }
            for (Object superIndex2 : (Integer)seed.getMixins()) {
                superItem = items.get((int)superIndex2);
                DartServerGotoSuperHandler.addSuperComponent(project, supers, isInClass, superItem);
            }
            for (Object superIndex2 : (Integer)seed.getInterfaces()) {
                superItem = items.get((int)superIndex2);
                DartServerGotoSuperHandler.addSuperComponent(project, supers, isInClass, superItem);
            }
        }
        String title = isInClass ? DartBundle.message("goto.super.class.chooser.title", new Object[0]) : CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]);
        NavigatablePsiElement[] targets = DartResolveUtil.getComponentNameArray(supers);
        PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])targets, (String)title, null, (ListCellRenderer)new DefaultPsiElementCellRenderer());
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        return file.getLanguage() == DartLanguage.INSTANCE;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void addSuperComponent(@NotNull Project project, List<DartComponent> supers, boolean isInClass, TypeHierarchyItem item) {
        Element itemElement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartServerGotoSuperHandler", "addSuperComponent"));
        }
        Element element = itemElement = isInClass ? item.getClassElement() : item.getMemberElement();
        if (itemElement == null) {
            return;
        }
        if ("CLASS".equals(itemElement.getKind()) && "Object".equals(itemElement.getName())) {
            return;
        }
        Location itemLocation = itemElement.getLocation();
        DartComponent itemComponent = DartHierarchyUtil.findDartComponent(project, itemLocation);
        if (itemComponent != null) {
            supers.add(itemComponent);
        }
    }
}

