/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.ide.actions.AbstractDartFileProcessingAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;

public class DartSortMembersAction
extends AbstractDartFileProcessingAction {
    private static final Logger LOG = Logger.getInstance((String)DartSortMembersAction.class.getName());

    public DartSortMembersAction() {
        super(DartBundle.message("dart.sort.members.action.name", new Object[0]), DartBundle.message("dart.sort.members.action.description", new Object[0]), null);
    }

    @Override
    @NotNull
    protected String getActionTextForEditor() {
        String string = DartBundle.message("dart.sort.members.action.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "getActionTextForEditor"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionTextForFiles() {
        String string = DartBundle.message("dart.sort.members.action.name.ellipsis", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "getActionTextForFiles"));
        }
        return string;
    }

    @Override
    protected void runOverEditor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "runOverEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "runOverEditor"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "runOverEditor"));
        }
        Document document = editor.getDocument();
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)document)) {
            return;
        }
        String path = psiFile.getVirtualFile().getPath();
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        service.updateFilesContent();
        SourceFileEdit fileEdit = service.edit_sortMembers(path);
        if (fileEdit == null) {
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.failed", new Object[0]), true);
            LOG.warn("Unexpected response from edit_sortMembers, fileEdit is null");
            return;
        }
        List<SourceEdit> edits = fileEdit.getEdits();
        if (edits == null || edits.size() == 0) {
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.already.good", new Object[0]), false);
            return;
        }
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverEditor$0"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverEditor$0"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverEditor$0"));
            }
            AssistUtils.applySourceEdits(project, psiFile.getVirtualFile(), document, edits, Collections.emptySet());
            DartSortMembersAction.showHintLater(editor, DartBundle.message("dart.sort.members.hint.success", new Object[0]), false);
        };
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverEditor$1"));
            }
            CommandProcessor.getInstance().executeCommand(project, runnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), null);
        });
    }

    @Override
    protected void runOverFiles(@NotNull Project project, @NotNull List<VirtualFile> dartFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "runOverFiles"));
        }
        if (dartFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartFiles", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "runOverFiles"));
        }
        if (dartFiles.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)DartBundle.message("dart.sort.members.files.no.dart.files", new Object[0]), (String)DartBundle.message("dart.sort.members.action.name", new Object[0]));
            return;
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DartBundle.message("dart.sort.members.files.dialog.question", dartFiles.size()), (String)DartBundle.message("dart.sort.members.action.name", new Object[0]), null) != 0) {
            return;
        }
        HashMap fileToFileEditMap = Maps.newHashMap();
        Runnable runnable = () -> {
            if (dartFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartFiles", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverFiles$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverFiles$2"));
            }
            double fraction = 0.0;
            for (VirtualFile virtualFile : dartFiles) {
                fraction += 1.0;
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setFraction(fraction / (double)dartFiles.size());
                    indicator.setText2(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
                }
                String path = virtualFile.getPath();
                SourceFileEdit fileEdit = DartAnalysisServerService.getInstance(project).edit_sortMembers(path);
                if (fileEdit == null) continue;
                fileToFileEditMap.put(virtualFile, fileEdit);
            }
        };
        DartAnalysisServerService.getInstance(project).updateFilesContent();
        boolean ok = ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(runnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), true, project);
        if (ok) {
            Runnable onSuccessRunnable = () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverFiles$3"));
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                for (Map.Entry entry : fileToFileEditMap.entrySet()) {
                    VirtualFile file = (VirtualFile)entry.getKey();
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    SourceFileEdit fileEdit = (SourceFileEdit)entry.getValue();
                    if (document == null) continue;
                    AssistUtils.applySourceEdits(project, file, document, fileEdit.getEdits(), Collections.emptySet());
                }
            };
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartSortMembersAction", "lambda$runOverFiles$4"));
                }
                CommandProcessor.getInstance().executeCommand(project, onSuccessRunnable, DartBundle.message("dart.sort.members.action.name", new Object[0]), null);
            });
        }
    }
}

