/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.actions.AbstractDartFileProcessingAction;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.jetbrains.annotations.NotNull;

public class DartStyleAction
extends AbstractDartFileProcessingAction {
    private static final Logger LOG = Logger.getInstance((String)DartStyleAction.class.getName());

    public DartStyleAction() {
        super(DartBundle.message("dart.style.action.name", new Object[0]), DartBundle.message("dart.style.action.description", new Object[0]), null);
    }

    @Override
    @NotNull
    protected String getActionTextForEditor() {
        String string = DartBundle.message("dart.style.action.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "getActionTextForEditor"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionTextForFiles() {
        String string = DartBundle.message("dart.style.action.name.ellipsis", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "getActionTextForFiles"));
        }
        return string;
    }

    @Override
    protected void runOverEditor(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "runOverEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "runOverEditor"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "runOverEditor"));
        }
        Document document = editor.getDocument();
        if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)document)) {
            return;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int lineLength = DartStyleAction.getRightMargin(project);
        DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
        das.updateFilesContent();
        DartAnalysisServerService.FormatResult formatResult = das.edit_format(psiFile.getVirtualFile(), caretOffset, 0, lineLength);
        if (formatResult == null) {
            DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.failed", new Object[0]), true);
            LOG.warn("Unexpected response from edit_format, formatResult is null");
            return;
        }
        Runnable runnable = () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverEditor$0"));
            }
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverEditor$0"));
            }
            List<SourceEdit> edits = formatResult.getEdits();
            if (edits == null || edits.size() == 0) {
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.already.good", new Object[0]), false);
            } else if (edits.size() == 1) {
                String replacement = StringUtil.convertLineSeparators((String)edits.get(0).getReplacement());
                document.replaceString(0, document.getTextLength(), (CharSequence)replacement);
                int offset = das.getConvertedOffset(psiFile.getVirtualFile(), formatResult.getOffset());
                editor.getCaretModel().moveToOffset(offset);
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.success", new Object[0]), false);
            } else {
                DartStyleAction.showHintLater(editor, DartBundle.message("dart.style.hint.failed", new Object[0]), true);
                LOG.warn("Unexpected response from edit_format, formatResult.getEdits().size() = " + edits.size());
            }
        };
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverEditor$1"));
            }
            CommandProcessor.getInstance().executeCommand(project, runnable, DartBundle.message("dart.style.action.name", new Object[0]), null);
        });
    }

    @Override
    protected void runOverFiles(@NotNull Project project, @NotNull List<VirtualFile> dartFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "runOverFiles"));
        }
        if (dartFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartFiles", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "runOverFiles"));
        }
        if (dartFiles.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)DartBundle.message("dart.style.files.no.dart.files", new Object[0]), (String)DartBundle.message("dart.style.action.name", new Object[0]));
            return;
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DartBundle.message("dart.style.files.dialog.question", dartFiles.size()), (String)DartBundle.message("dart.style.action.name", new Object[0]), null) != 0) {
            return;
        }
        THashMap fileToNewContentMap = new THashMap();
        int lineLength = DartStyleAction.getRightMargin(project);
        Runnable runnable = () -> DartStyleAction.lambda$runOverFiles$2(dartFiles, project, lineLength, (Map)fileToNewContentMap);
        DartAnalysisServerService.getInstance(project).updateFilesContent();
        boolean ok = ApplicationManagerEx.getApplicationEx().runProcessWithProgressSynchronously(runnable, DartBundle.message("dart.style.action.name", new Object[0]), true, project);
        if (ok) {
            Runnable onSuccessRunnable = () -> DartStyleAction.lambda$runOverFiles$3(project, (Map)fileToNewContentMap);
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverFiles$4"));
                }
                CommandProcessor.getInstance().executeCommand(project, onSuccessRunnable, DartBundle.message("dart.style.action.name", new Object[0]), null);
            });
        }
    }

    private static int getRightMargin(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "getRightMargin"));
        }
        return CodeStyleSettingsManager.getSettings((Project)project).getCommonSettings((Language)DartLanguage.INSTANCE).RIGHT_MARGIN;
    }

    private static /* synthetic */ void lambda$runOverFiles$3(@NotNull Project project, Map fileToNewContentMap) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverFiles$3"));
        }
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
        for (Map.Entry entry : fileToNewContentMap.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            Document document = FileDocumentManager.getInstance().getDocument(file);
            String newContent = (String)entry.getValue();
            if (document == null || newContent == null) continue;
            document.setText((CharSequence)newContent);
        }
    }

    private static /* synthetic */ void lambda$runOverFiles$2(@NotNull List dartFiles, @NotNull Project project, int lineLength, Map fileToNewContentMap) {
        if (dartFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dartFiles", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverFiles$2"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/actions/DartStyleAction", "lambda$runOverFiles$2"));
        }
        double fraction = 0.0;
        for (VirtualFile virtualFile : dartFiles) {
            DartAnalysisServerService.FormatResult formatResult;
            fraction += 1.0;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setFraction(fraction / (double)dartFiles.size());
                indicator.setText2(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
            }
            if ((formatResult = DartAnalysisServerService.getInstance(project).edit_format(virtualFile, 0, 0, lineLength)) == null || formatResult.getEdits() == null || formatResult.getEdits().size() != 1) continue;
            String replacement = StringUtil.convertLineSeparators((String)formatResult.getEdits().get(0).getReplacement());
            fileToNewContentMap.put(virtualFile, replacement);
        }
    }
}

