/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemGroup
implements SuppressableProblemGroup {
    @NotNull
    private String myErrorCode;
    @NotNull
    private String myErrorSeverity;

    public DartProblemGroup(@NotNull String errorCode, @NotNull String errorSeverity) {
        if (errorCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCode", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup", "<init>"));
        }
        if (errorSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSeverity", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup", "<init>"));
        }
        this.myErrorCode = errorCode;
        this.myErrorSeverity = errorSeverity;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        SuppressIntentionAction[] suppressIntentionActionArray = new SuppressIntentionAction[]{new DartSuppressAction(this.myErrorCode, this.myErrorSeverity, false), new DartSuppressAction(this.myErrorCode, this.myErrorSeverity, true)};
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup", "getSuppressActions"));
        }
        return suppressIntentionActionArray;
    }

    @Nullable
    public String getProblemName() {
        return null;
    }

    public static class DartSuppressAction
    extends SuppressIntentionAction
    implements Comparable<IntentionAction> {
        public static final String IGNORE_PREFIX = "ignore:";
        @NotNull
        private final String myErrorCode;
        private final boolean myEolComment;

        public DartSuppressAction(@NotNull String errorCode, @NotNull String errorSeverity, boolean eolComment) {
            if (errorCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCode", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "<init>"));
            }
            if (errorSeverity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSeverity", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "<init>"));
            }
            this.myErrorCode = errorCode;
            this.myEolComment = eolComment;
            this.setText("Suppress " + errorSeverity.toLowerCase(Locale.US) + (eolComment ? " with EOL comment" : " with comment"));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress errors and warnings in Dart code" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "getFamilyName"));
            }
            return "Suppress errors and warnings in Dart code";
        }

        @Override
        public int compareTo(IntentionAction o) {
            if (o instanceof DartSuppressAction) {
                return ((DartSuppressAction)o).myEolComment ? -1 : 1;
            }
            return 0;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "isAvailable"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "isAvailable"));
            }
            if (editor == null) {
                return false;
            }
            Document document = editor.getDocument();
            int line = document.getLineNumber(element.getTextRange().getStartOffset());
            if (this.myEolComment) {
                return !DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line) || DartSuppressAction.hasEolIgnoreComment(document, line);
            }
            return !DartSuppressAction.hasEolIgnoreComment(document, line) || DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line);
        }

        private static boolean hasEolIgnoreComment(@NotNull Document document, int line) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "hasEolIgnoreComment"));
            }
            CharSequence lineText = document.getCharsSequence().subSequence(document.getLineStartOffset(line), document.getLineEndOffset(line));
            if (!StringUtil.contains((CharSequence)lineText, (CharSequence)IGNORE_PREFIX)) {
                return false;
            }
            int index = lineText.toString().lastIndexOf(IGNORE_PREFIX);
            block4: while (index > 0) {
                char ch = lineText.charAt(--index);
                switch (ch) {
                    case ' ': {
                        continue block4;
                    }
                    case '/': {
                        return index >= 2 && lineText.charAt(index - 1) == '/' && lineText.charAt(index - 2) != '/';
                    }
                }
                return false;
            }
            return false;
        }

        private static boolean hasIgnoreCommentOnPrevLine(@NotNull Document document, int line) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "hasIgnoreCommentOnPrevLine"));
            }
            if (line == 0) {
                return false;
            }
            CharSequence prevLine = document.getCharsSequence().subSequence(document.getLineStartOffset(line - 1), document.getLineEndOffset(line - 1));
            int index = -1;
            block4: while (++index < prevLine.length()) {
                char ch = prevLine.charAt(index);
                switch (ch) {
                    case ' ': {
                        continue block4;
                    }
                    case '/': {
                        String comment;
                        return prevLine.length() > index + 1 && prevLine.charAt(index + 1) == '/' && StringUtil.trimLeading((String)(comment = prevLine.subSequence(index + 2, prevLine.length()).toString()), (char)' ').startsWith(IGNORE_PREFIX);
                    }
                }
                return false;
            }
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "invoke"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "invoke"));
            }
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            int line = document.getLineNumber(element.getTextRange().getStartOffset());
            if (this.myEolComment) {
                if (DartSuppressAction.hasEolIgnoreComment(document, line)) {
                    DartSuppressAction.appendErrorCode(document, line, this.myErrorCode);
                } else {
                    DartSuppressAction.addEolComment(document, line, this.myErrorCode);
                }
            } else if (DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line)) {
                DartSuppressAction.appendErrorCode(document, line - 1, this.myErrorCode);
            } else {
                DartSuppressAction.addCommentOnPrevLine(document, line, this.myErrorCode);
            }
        }

        private static void appendErrorCode(@NotNull Document document, int line, @NotNull String errorCode) {
            int index;
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "appendErrorCode"));
            }
            if (errorCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCode", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "appendErrorCode"));
            }
            int lineEndOffset = document.getLineEndOffset(line);
            for (index = lineEndOffset - 1; index >= 0 && document.getCharsSequence().charAt(index) == ' '; --index) {
            }
            document.replaceString(index + 1, lineEndOffset, (CharSequence)(", " + errorCode));
        }

        private static void addEolComment(@NotNull Document document, int line, @NotNull String errorCode) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "addEolComment"));
            }
            if (errorCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCode", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "addEolComment"));
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
            int commentIndex = StringUtil.indexOf((CharSequence)lineText, (CharSequence)"//");
            if (commentIndex >= 0) {
                document.insertString(lineStartOffset + commentIndex, (CharSequence)("// ignore: " + errorCode + ", "));
            } else {
                int index;
                for (index = lineEndOffset - 1; index >= 0 && document.getCharsSequence().charAt(index) == ' '; --index) {
                }
                document.replaceString(index + 1, lineEndOffset, (CharSequence)(" // ignore: " + errorCode));
            }
        }

        private static void addCommentOnPrevLine(@NotNull Document document, int line, @NotNull String errorCode) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "addCommentOnPrevLine"));
            }
            if (errorCode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCode", "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction", "addCommentOnPrevLine"));
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int offset = 0;
            while (document.getCharsSequence().charAt(lineStartOffset + offset) == ' ') {
                ++offset;
            }
            document.insertString(lineStartOffset, (CharSequence)(StringUtil.repeat((String)" ", (int)offset) + "// ignore: " + errorCode + "\n"));
        }
    }
}

