/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartVisitor;
import org.jetbrains.annotations.NotNull;

public class DartUnresolvedReferenceVisitor
extends DartVisitor
implements Annotator {
    private AnnotationHolder myHolder = null;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/annotator/DartUnresolvedReferenceVisitor", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/lang/dart/ide/annotator/DartUnresolvedReferenceVisitor", "annotate"));
        }
        assert (this.myHolder == null);
        this.myHolder = holder;
        try {
            element.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull DartReferenceExpression reference) {
        boolean isSimpleReference;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/ide/annotator/DartUnresolvedReferenceVisitor", "visitReferenceExpression"));
        }
        String referenceText = reference.getText();
        boolean bl = isSimpleReference = referenceText != null && !"void".equals(referenceText) && !referenceText.contains(".");
        if (isSimpleReference && reference.resolve() == null) {
            this.myHolder.createErrorAnnotation((PsiElement)reference, DartBundle.message("cannot.resolve.reference", new Object[0]));
        }
        super.visitReferenceExpression(reference);
    }
}

