/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.completion;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.psi.DartComponentName;
import org.dartlang.analysis.server.protocol.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartLookupObject
implements ResolveResult {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Location myLocation;

    public DartLookupObject(@NotNull Project project, @Nullable Location location) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/completion/DartLookupObject", "<init>"));
        }
        this.myProject = project;
        this.myLocation = location;
    }

    @Nullable
    public PsiElement getElement() {
        PsiFile psiFile;
        String filePath = this.myLocation == null ? null : FileUtil.toSystemIndependentName((String)this.myLocation.getFile());
        VirtualFile vFile = filePath == null ? null : LocalFileSystem.getInstance().findFileByPath(filePath);
        PsiFile psiFile2 = psiFile = vFile == null ? null : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        if (psiFile != null) {
            int offset = DartAnalysisServerService.getInstance(this.myProject).getConvertedOffset(vFile, this.myLocation.getOffset());
            PsiElement elementAtOffset = psiFile.findElementAt(offset);
            return PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, DartComponentName.class);
        }
        return null;
    }

    public boolean isValidResult() {
        return true;
    }
}

