/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.codeInsight.DartCodeInsightSettings;
import com.jetbrains.lang.dart.ide.completion.DartLookupObject;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerCompletionContributor
extends CompletionContributor {
    public DartServerCompletionContributor() {
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withLanguage(DartLanguage.INSTANCE), PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withLanguage((Language)HTMLLanguage.INSTANCE)), PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withName(".analysis_options"))}), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet originalResultSet) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$1", "addCompletions"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$1", "addCompletions"));
                }
                if (originalResultSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalResultSet", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$1", "addCompletions"));
                }
                VirtualFile file = DartResolveUtil.getRealVirtualFile(parameters.getOriginalFile());
                if (file instanceof VirtualFileWindow) {
                    file = ((VirtualFileWindow)file).getDelegate();
                }
                if (file == null) {
                    return;
                }
                Project project = parameters.getOriginalFile().getProject();
                if (file.getFileType() == HtmlFileType.INSTANCE && PubspecYamlUtil.findPubspecYamlFile(project, file) == null) {
                    return;
                }
                DartSdk sdk = DartSdk.getDartSdk(project);
                if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
                    return;
                }
                DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
                das.updateFilesContent();
                int offset = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)parameters.getOriginalFile(), parameters.getOffset());
                String completionId = das.completion_getSuggestions(file, offset);
                if (completionId == null) {
                    return;
                }
                String uriPrefix = DartServerCompletionContributor.getPrefixIfCompletingUri(parameters);
                CompletionResultSet resultSet = uriPrefix != null ? originalResultSet.withPrefixMatcher(uriPrefix) : originalResultSet;
                das.addCompletions(file, completionId, (int replacementOffset, int replacementLength, CompletionSuggestion suggestion) -> {
                    String specialPrefix;
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$1", "lambda$addCompletions$0"));
                    }
                    CompletionResultSet updatedResultSet = uriPrefix != null ? resultSet : ((specialPrefix = DartServerCompletionContributor.getPrefixForSpecialCases(parameters, replacementOffset)) != null ? resultSet.withPrefixMatcher(specialPrefix) : resultSet);
                    LookupElement lookupElement = DartServerCompletionContributor.createLookupElement(project, suggestion);
                    updatedResultSet.addElement(lookupElement);
                });
            }
        });
    }

    @Nullable
    private static String getPrefixIfCompletingUri(@NotNull CompletionParameters parameters) {
        PsiElement parentParent;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "getPrefixIfCompletingUri"));
        }
        PsiElement psiElement = parameters.getOriginalPosition();
        PsiElement parent = psiElement != null ? psiElement.getParent() : null;
        PsiElement psiElement2 = parentParent = parent instanceof DartStringLiteralExpression ? parent.getParent() : null;
        if (parentParent instanceof DartUriElement) {
            int uriStringOffset = ((TextRange)((DartUriElement)parentParent).getUriStringAndItsRange().second).getStartOffset();
            if (parameters.getOffset() >= parentParent.getTextRange().getStartOffset() + uriStringOffset) {
                return parentParent.getText().substring(uriStringOffset, parameters.getOffset() - parentParent.getTextRange().getStartOffset());
            }
        }
        return null;
    }

    @Nullable
    private static String getPrefixForSpecialCases(@NotNull CompletionParameters parameters, int replacementOffset) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "getPrefixForSpecialCases"));
        }
        PsiElement psiElement = parameters.getOriginalPosition();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement.getParent();
        Language language = psiElement.getContainingFile().getLanguage();
        if (parent instanceof DartStringLiteralExpression || language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            return DartServerCompletionContributor.getPrefixUsingServerData(parameters, replacementOffset);
        }
        return null;
    }

    @Nullable
    private static String getPrefixUsingServerData(@NotNull CompletionParameters parameters, int replacementOffset) {
        int elementStartOffset;
        TextRange range;
        PsiFile injectedContext;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "getPrefixUsingServerData"));
        }
        PsiElement element = parameters.getOriginalPosition();
        if (element == null) {
            return null;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        int completionOffset = manager.injectedToHost((PsiElement)(injectedContext = parameters.getOriginalFile()), parameters.getOffset());
        if (completionOffset < (range = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange())).getStartOffset() || completionOffset > range.getEndOffset()) {
            return null;
        }
        if (replacementOffset > completionOffset) {
            return null;
        }
        while (element != null && (elementStartOffset = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange().getStartOffset())) > replacementOffset) {
            element = element.getParent();
        }
        if (element != null) {
            int startOffset = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange().getStartOffset());
            return element.getText().substring(replacementOffset - startOffset, completionOffset - startOffset);
        }
        return null;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement parent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "beforeCompletion"));
        }
        PsiElement psiElement = context.getFile().findElementAt(context.getStartOffset());
        PsiElement psiElement2 = parent = psiElement != null ? psiElement.getParent() : null;
        if (parent instanceof DartStringLiteralExpression) {
            PsiElement parentParent = parent.getParent();
            if (parentParent instanceof DartUriElement) {
                Pair<String, TextRange> uriAndRange = ((DartUriElement)parentParent).getUriStringAndItsRange();
                context.setReplacementOffset(parentParent.getTextRange().getStartOffset() + ((TextRange)uriAndRange.second).getEndOffset());
            } else {
                context.setReplacementOffset(context.getReplacementOffset());
            }
        } else {
            PsiReference reference = context.getFile().findReferenceAt(context.getStartOffset());
            if (reference instanceof PsiMultiReference && ((PsiMultiReference)reference).getReferences().length > 0) {
                reference.getRangeInElement();
                reference = ((PsiMultiReference)reference).getReferences()[0];
            }
            if (reference instanceof DartNewExpression) {
                context.setReplacementOffset(context.getStartOffset());
            }
        }
    }

    private static Icon applyOverlay(Icon base, boolean condition, Icon overlay) {
        if (condition) {
            return new LayeredIcon(new Icon[]{base, overlay});
        }
        return base;
    }

    private static Icon applyVisibility(Icon base, boolean isPrivate) {
        RowIcon result = new RowIcon(2);
        result.setIcon(base, 0);
        Icon visibility = isPrivate ? PlatformIcons.PRIVATE_ICON : PlatformIcons.PUBLIC_ICON;
        result.setIcon(visibility, 1);
        return result;
    }

    private static LookupElement createLookupElement(@NotNull Project project, @NotNull CompletionSuggestion suggestion) {
        int dotIndex;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "createLookupElement"));
        }
        if (suggestion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestion", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "createLookupElement"));
        }
        Element element = suggestion.getElement();
        Location location = element == null ? null : element.getLocation();
        DartLookupObject lookupObject = new DartLookupObject(project, location);
        String lookupString = suggestion.getCompletion();
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)lookupObject, (String)lookupString);
        if (suggestion.getKind().equals("KEYWORD")) {
            lookup = lookup.bold();
        }
        if ((dotIndex = lookupString.indexOf(46)) > 0 && dotIndex < lookupString.length() - 1 && StringUtil.isJavaIdentifier((String)lookupString.substring(0, dotIndex)) && StringUtil.isJavaIdentifier((String)lookupString.substring(dotIndex + 1))) {
            lookup = lookup.withLookupString(lookupString.substring(dotIndex + 1));
        }
        boolean shouldSetSelection = true;
        if (element != null) {
            Icon icon;
            String returnType;
            String parameters;
            String typeParameters;
            if (element.isDeprecated()) {
                lookup = lookup.strikeout();
            }
            if ((typeParameters = element.getTypeParameters()) != null) {
                lookup = lookup.appendTailText(typeParameters, false);
            }
            if ((parameters = element.getParameters()) != null) {
                lookup = lookup.appendTailText(parameters, false);
            }
            if (!StringUtils.isEmpty((CharSequence)(returnType = element.getReturnType()))) {
                lookup = lookup.withTypeText(returnType, true);
            }
            if ((icon = DartServerCompletionContributor.getBaseImage(element)) != null) {
                icon = DartServerCompletionContributor.applyVisibility(icon, element.isPrivate());
                icon = DartServerCompletionContributor.applyOverlay(icon, element.isFinal(), AllIcons.Nodes.FinalMark);
                icon = DartServerCompletionContributor.applyOverlay(icon, element.isConst(), AllIcons.Nodes.FinalMark);
                lookup = lookup.withIcon(icon);
            }
            if ("INVOCATION".equals(suggestion.getKind())) {
                shouldSetSelection = false;
                List<String> parameterNames = suggestion.getParameterNames();
                if (parameterNames != null) {
                    lookup = lookup.withInsertHandler((context, item) -> {
                        if (suggestion == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestion", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "lambda$createLookupElement$0"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "lambda$createLookupElement$0"));
                        }
                        if (parameterNames.isEmpty()) {
                            ParenthesesInsertHandler.NO_PARAMETERS.handleInsert(context, item);
                        } else {
                            String argumentListString;
                            ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
                            Editor editor = context.getEditor();
                            PsiElement psiElement = lookupObject.getElement();
                            if (DartCodeInsightSettings.getInstance().INSERT_DEFAULT_ARG_VALUES && (argumentListString = suggestion.getDefaultArgumentListString()) != null) {
                                Document document = editor.getDocument();
                                int offset = editor.getCaretModel().getOffset();
                                CharSequence text = document.getCharsSequence();
                                if (text.charAt(offset - 1) == '(' && text.charAt(offset) == ')') {
                                    document.insertString(offset, (CharSequence)argumentListString);
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                                    TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context.getFile());
                                    int[] ranges = suggestion.getDefaultArgumentListTextRanges();
                                    if (ranges != null && (ranges.length & 1) == 0) {
                                        int index = 0;
                                        while (index < ranges.length) {
                                            int start = ranges[index];
                                            int length = ranges[index + 1];
                                            String arg = argumentListString.substring(start, start + length);
                                            TextExpression expression = new TextExpression(arg);
                                            TextRange range = new TextRange(offset + start, offset + start + length);
                                            builder.replaceRange(range, "group_" + ((index += 2) - 1), (Expression)expression, true);
                                        }
                                        builder.run(editor, true);
                                    }
                                }
                            }
                            AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, psiElement);
                        }
                    });
                }
            }
        }
        if (shouldSetSelection) {
            lookup = lookup.withInsertHandler((context, item) -> {
                if (suggestion == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestion", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor", "lambda$createLookupElement$1"));
                }
                Editor editor = context.getEditor();
                int startOffset = context.getStartOffset() + suggestion.getSelectionOffset();
                int endOffset = startOffset + suggestion.getSelectionLength();
                editor.getCaretModel().moveToOffset(startOffset);
                if (endOffset > startOffset) {
                    editor.getSelectionModel().setSelection(startOffset, endOffset);
                }
            });
        }
        return PrioritizedLookupElement.withPriority((LookupElement)lookup, (double)suggestion.getRelevance());
    }

    private static Icon getBaseImage(Element element) {
        String elementKind = element.getKind();
        if (elementKind.equals("CLASS") || elementKind.equals("CLASS_TYPE_ALIAS")) {
            if (element.isAbstract()) {
                return AllIcons.Nodes.AbstractClass;
            }
            return AllIcons.Nodes.Class;
        }
        if (elementKind.equals("ENUM")) {
            return AllIcons.Nodes.Enum;
        }
        if (elementKind.equals("ENUM_CONSTANT") || elementKind.equals("FIELD")) {
            return AllIcons.Nodes.Field;
        }
        if (elementKind.equals("COMPILATION_UNIT")) {
            return PlatformIcons.FILE_ICON;
        }
        if (elementKind.equals("CONSTRUCTOR")) {
            return AllIcons.Nodes.ClassInitializer;
        }
        if (elementKind.equals("GETTER")) {
            return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (elementKind.equals("SETTER")) {
            return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        if (elementKind.equals("METHOD")) {
            if (element.isAbstract()) {
                return AllIcons.Nodes.AbstractMethod;
            }
            return AllIcons.Nodes.Method;
        }
        if (elementKind.equals("FUNCTION")) {
            return AllIcons.Nodes.Function;
        }
        if (elementKind.equals("FUNCTION_TYPE_ALIAS")) {
            return AllIcons.Nodes.Annotationtype;
        }
        if (elementKind.equals("TOP_LEVEL_VARIABLE")) {
            return AllIcons.Nodes.Variable;
        }
        return null;
    }
}

