/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.documentation.DartDocUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.Collections;
import java.util.List;
import org.dartlang.analysis.server.protocol.HoverInformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartDocumentationProvider
implements DocumentationProvider {
    private static final String BASE_DART_DOC_URL = "https://api.dartlang.org/stable/";

    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "generateDoc"));
        }
        PsiElement elementForDocs = DartDocumentationProvider.resolvesTo(originalElement, element) ? originalElement : element;
        HoverInformation hover = DartDocumentationProvider.getSingleHover(elementForDocs);
        if (hover != null) {
            return DartDocumentationProvider.generateDocServer(hover);
        }
        return DartDocUtil.generateDoc(element);
    }

    private static boolean resolvesTo(@Nullable PsiElement originalElement, @NotNull PsiElement target) {
        PsiReference reference;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "resolvesTo"));
        }
        if (originalElement instanceof PsiReference) {
            reference = (PsiReference)originalElement;
        } else {
            PsiElement parentParent;
            PsiElement parent = originalElement == null ? null : originalElement.getParent();
            PsiElement psiElement = parentParent = parent instanceof DartId ? parent.getParent() : null;
            if (parentParent == null) {
                return false;
            }
            if (parentParent == target) {
                return true;
            }
            if (!parentParent.getText().equals(target.getText())) {
                return false;
            }
            reference = parentParent.getReference();
        }
        return reference != null && reference.resolve() == target;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        PsiElement elementForInfo = DartDocumentationProvider.resolvesTo(originalElement, element) ? originalElement : element;
        HoverInformation hover = DartDocumentationProvider.getSingleHover(elementForInfo);
        if (hover != null) {
            return DartDocumentationProvider.buildHoverTextServer(hover);
        }
        return DartDocUtil.getSignature(element);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (!(element instanceof DartComponent) && !(element.getParent() instanceof DartComponent)) {
            return null;
        }
        DartComponent component = (DartComponent)(element instanceof DartComponent ? element : element.getParent());
        if (!component.isPublic()) {
            return null;
        }
        String docUrl = DartDocumentationProvider.constructDocUrl(component);
        return docUrl == null ? null : Collections.singletonList(docUrl);
    }

    @NotNull
    public static String buildHoverTextServer(@NotNull HoverInformation hover) {
        if (hover == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hover", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "buildHoverTextServer"));
        }
        String elementDescription = hover.getElementDescription();
        String staticType = elementDescription == null || elementDescription.equals(hover.getStaticType()) ? null : hover.getStaticType();
        String propagatedType = elementDescription == null || elementDescription.equals(hover.getPropagatedType()) ? null : hover.getPropagatedType();
        String string = DartDocUtil.generateDoc(elementDescription, false, null, null, null, staticType, propagatedType, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "buildHoverTextServer"));
        }
        return string;
    }

    @NotNull
    public static String generateDocServer(@NotNull HoverInformation hover) {
        if (hover == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hover", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "generateDocServer"));
        }
        String elementDescription = hover.getElementDescription();
        String containingLibraryName = hover.getContainingLibraryName();
        String containingClassDescription = hover.getContainingClassDescription();
        String staticType = hover.getStaticType();
        String propagatedType = hover.getPropagatedType();
        String docText = hover.getDartdoc();
        String string = DartDocUtil.generateDoc(elementDescription, false, docText, containingLibraryName, containingClassDescription, staticType, propagatedType, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "generateDocServer"));
        }
        return string;
    }

    @Nullable
    public static HoverInformation getSingleHover(@NotNull PsiFile psiFile, int offset) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "getSingleHover"));
        }
        List<HoverInformation> hoverList = DartAnalysisServerService.getInstance(psiFile.getProject()).analysis_getHover(psiFile.getVirtualFile(), offset);
        if (hoverList.isEmpty()) {
            return null;
        }
        return hoverList.get(0);
    }

    @Nullable
    private static String constructDocUrl(@NotNull DartComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "constructDocUrl"));
        }
        String libRelatedUrlPart = DartDocumentationProvider.getLibRelatedUrlPart((PsiElement)component);
        String name = component.getName();
        if (libRelatedUrlPart == null || name == null) {
            return null;
        }
        String baseUrl = BASE_DART_DOC_URL + libRelatedUrlPart + "/";
        if (component instanceof DartClass) {
            return baseUrl + name + "-class.html";
        }
        DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)component, DartClass.class, (boolean)true);
        if (component instanceof DartNamedConstructorDeclaration) {
            assert (dartClass != null);
            return baseUrl + dartClass.getName() + "/" + StringUtil.join(((DartNamedConstructorDeclaration)component).getComponentNameList(), cName -> cName.getName(), (String)".") + ".html";
        }
        if (component instanceof DartFactoryConstructorDeclaration) {
            assert (dartClass != null);
            return baseUrl + dartClass.getName() + "/" + StringUtil.join(((DartFactoryConstructorDeclaration)component).getComponentNameList(), cName -> cName.getName(), (String)".") + ".html";
        }
        if (dartClass != null) {
            return baseUrl + dartClass.getName() + "/" + name + ".html";
        }
        return baseUrl + name + ".html";
    }

    @Nullable
    private static String getLibRelatedUrlPart(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider", "getLibRelatedUrlPart"));
        }
        for (VirtualFile libFile : DartResolveUtil.findLibrary(element.getContainingFile())) {
            DartUrlResolver urlResolver = DartUrlResolver.getInstance(element.getProject(), libFile);
            String dartUrl = urlResolver.getDartUrlForFile(libFile);
            if (!dartUrl.startsWith("dart:")) continue;
            return "dart-" + dartUrl.substring("dart:".length());
        }
        return null;
    }

    @Nullable
    private static HoverInformation getSingleHover(PsiElement element) {
        if (element != null) {
            PsiFile psiFile = element.getContainingFile();
            int offset = element.getTextOffset();
            return DartDocumentationProvider.getSingleHover(psiFile, offset);
        }
        return null;
    }
}

